/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Objects;

final class PlanNodeMatcher
implements Matcher {
    private final Class<? extends PlanNode> nodeClass;

    public PlanNodeMatcher(Class<? extends PlanNode> nodeClass) {
        this.nodeClass = Objects.requireNonNull(nodeClass, "nodeClass is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node.getClass().equals(this.nodeClass);
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeClass", this.nodeClass).toString();
    }

    public Class<? extends PlanNode> getNodeClass() {
        return this.nodeClass;
    }
}

