/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.ExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class SemiJoinMatcher
implements Matcher {
    private final String sourceSymbolAlias;
    private final String filteringSymbolAlias;
    private final String outputAlias;
    private final Optional<SemiJoinNode.DistributionType> distributionType;
    private final Optional<Boolean> hasDynamicFilter;

    SemiJoinMatcher(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, Optional<SemiJoinNode.DistributionType> distributionType, Optional<Boolean> hasDynamicFilter) {
        this.sourceSymbolAlias = Objects.requireNonNull(sourceSymbolAlias, "sourceSymbolAlias is null");
        this.filteringSymbolAlias = Objects.requireNonNull(filteringSymbolAlias, "filteringSymbolAlias is null");
        this.outputAlias = Objects.requireNonNull(outputAlias, "outputAlias is null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
        this.hasDynamicFilter = Objects.requireNonNull(hasDynamicFilter, "hasDynamicFilter is null ");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof SemiJoinNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        SemiJoinNode semiJoinNode = (SemiJoinNode)node;
        if (!symbolAliases.get(this.sourceSymbolAlias).equals((Object)semiJoinNode.getSourceJoinSymbol().toSymbolReference()) || !symbolAliases.get(this.filteringSymbolAlias).equals((Object)semiJoinNode.getFilteringSourceJoinSymbol().toSymbolReference())) {
            return MatchResult.NO_MATCH;
        }
        if (this.distributionType.isPresent() && !this.distributionType.equals(semiJoinNode.getDistributionType())) {
            return MatchResult.NO_MATCH;
        }
        if (this.hasDynamicFilter.isPresent()) {
            if (this.hasDynamicFilter.get().booleanValue()) {
                if (semiJoinNode.getDynamicFilterId().isEmpty()) {
                    return MatchResult.NO_MATCH;
                }
                DynamicFilterId dynamicFilterId = (DynamicFilterId)semiJoinNode.getDynamicFilterId().get();
                List matchingDescriptors = (List)PlanNodeSearcher.searchFrom((PlanNode)semiJoinNode.getSource()).where(FilterNode.class::isInstance).findAll().stream().flatMap(filterNode -> ExpressionExtractor.extractExpressions((PlanNode)filterNode).stream()).flatMap(expression -> DynamicFilters.extractDynamicFilters((Expression)expression).getDynamicConjuncts().stream()).filter(descriptor -> descriptor.getId().equals((Object)dynamicFilterId)).collect(ImmutableList.toImmutableList());
                boolean sourceSymbolsMatch = matchingDescriptors.stream().map(descriptor -> Symbol.from((Expression)descriptor.getInput())).allMatch(sourceSymbol -> symbolAliases.get(this.sourceSymbolAlias).equals((Object)sourceSymbol.toSymbolReference()));
                if (!matchingDescriptors.isEmpty() && sourceSymbolsMatch) {
                    return MatchResult.match(this.outputAlias, semiJoinNode.getSemiJoinOutput().toSymbolReference());
                }
                return MatchResult.NO_MATCH;
            }
            if (semiJoinNode.getDynamicFilterId().isPresent()) {
                return MatchResult.NO_MATCH;
            }
        }
        return MatchResult.match(this.outputAlias, semiJoinNode.getSemiJoinOutput().toSymbolReference());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filteringSymbolAlias", (Object)this.filteringSymbolAlias).add("sourceSymbolAlias", (Object)this.sourceSymbolAlias).add("outputAlias", (Object)this.outputAlias).add("distributionType", this.distributionType).add("hasDynamicFilter", this.hasDynamicFilter).toString();
    }
}

