/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SetOperationNode;
import java.util.Optional;

public class SetOperationOutputMatcher
implements RvalueMatcher {
    private final int index;

    public SetOperationOutputMatcher(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index cannot be negative");
        this.index = index;
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        if (!(node instanceof SetOperationNode)) {
            return Optional.empty();
        }
        SetOperationNode setOperationNode = (SetOperationNode)node;
        if (this.index >= setOperationNode.getOutputSymbols().size()) {
            return Optional.empty();
        }
        return Optional.of((Symbol)node.getOutputSymbols().get(this.index));
    }
}

