/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.Util;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SortNode;
import java.util.List;
import java.util.Objects;

final class SortMatcher
implements Matcher {
    private final List<PlanMatchPattern.Ordering> orderBy;

    public SortMatcher(List<PlanMatchPattern.Ordering> orderBy) {
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof SortNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        SortNode sortNode = (SortNode)node;
        if (!Util.orderingSchemeMatches(this.orderBy, sortNode.getOrderingScheme(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orderBy", this.orderBy).toString();
    }
}

