/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class SymbolAliases {
    private final Map<String, SymbolReference> map;

    public SymbolAliases() {
        this.map = ImmutableMap.of();
    }

    private SymbolAliases(Map<String, SymbolReference> aliases) {
        this.map = ImmutableMap.copyOf(aliases);
    }

    public SymbolAliases(SymbolAliases symbolAliases) {
        Objects.requireNonNull(symbolAliases, "symbolAliases are null");
        this.map = ImmutableMap.copyOf(symbolAliases.map);
    }

    public static Builder builder() {
        return new Builder();
    }

    public SymbolAliases withNewAliases(SymbolAliases sourceAliases) {
        Builder builder = new Builder(this);
        for (Map.Entry<String, SymbolReference> alias : sourceAliases.map.entrySet()) {
            builder.put(alias.getKey(), alias.getValue());
        }
        return builder.build();
    }

    public SymbolReference get(String alias) {
        return this.getOptional(alias).orElseThrow(() -> new IllegalStateException(String.format("missing expression for alias %s", alias)));
    }

    public Optional<SymbolReference> getOptional(String alias) {
        SymbolReference result = this.map.get(alias);
        return Optional.ofNullable(result);
    }

    private Map<String, SymbolReference> getUpdatedAssignments(Assignments assignments) {
        ImmutableMap.Builder mapUpdate = ImmutableMap.builder();
        for (Map.Entry assignment : assignments.getMap().entrySet()) {
            for (Map.Entry<String, SymbolReference> existingAlias : this.map.entrySet()) {
                if (((Expression)assignment.getValue()).equals((Object)existingAlias.getValue())) {
                    mapUpdate.put((Object)existingAlias.getKey(), (Object)((Symbol)assignment.getKey()).toSymbolReference());
                    continue;
                }
                if (!((Symbol)assignment.getKey()).toSymbolReference().equals((Object)existingAlias.getValue())) continue;
                mapUpdate.put((Object)existingAlias.getKey(), (Object)existingAlias.getValue());
            }
        }
        return mapUpdate.build();
    }

    public SymbolAliases updateAssignments(Assignments assignments) {
        return SymbolAliases.builder().putAll(this).putUnchecked(this.getUpdatedAssignments(assignments)).build();
    }

    public SymbolAliases replaceAssignments(Assignments assignments) {
        return new SymbolAliases(this.getUpdatedAssignments(assignments));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.map).toString();
    }

    public static class Builder {
        Map<String, SymbolReference> bindings;

        private Builder() {
            this.bindings = new HashMap<String, SymbolReference>();
        }

        private Builder(SymbolAliases initialAliases) {
            this.bindings = new HashMap<String, SymbolReference>(initialAliases.map);
        }

        public Builder put(String alias, SymbolReference symbolReference) {
            Objects.requireNonNull(alias, "alias is null");
            Objects.requireNonNull(symbolReference, "symbolReference is null");
            if (this.bindings.containsKey(alias) && this.bindings.get(alias).equals((Object)symbolReference)) {
                return this;
            }
            Preconditions.checkState((!this.bindings.containsKey(alias) ? 1 : 0) != 0, (String)"Alias '%s' already bound to expression '%s'. Tried to rebind to '%s'", (Object)alias, (Object)this.bindings.get(alias), (Object)symbolReference);
            this.bindings.put(alias, symbolReference);
            return this;
        }

        public Builder putAll(Map<String, SymbolReference> aliases) {
            aliases.entrySet().forEach(entry -> this.put((String)entry.getKey(), (SymbolReference)entry.getValue()));
            return this;
        }

        private Builder putUnchecked(Map<String, SymbolReference> aliases) {
            this.bindings.putAll(aliases);
            return this;
        }

        public Builder putAll(SymbolAliases aliases) {
            return this.putAll(aliases.map);
        }

        public SymbolAliases build() {
            return new SymbolAliases(this.bindings);
        }
    }
}

