/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.SortOrder;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAlias;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TopNRowNumberMatcher
implements Matcher {
    private final Optional<ExpectedValueProvider<WindowNode.Specification>> specification;
    private final Optional<SymbolAlias> rowNumberSymbol;
    private final Optional<Integer> maxRowCountPerPartition;
    private final Optional<Boolean> partial;
    private final Optional<Optional<SymbolAlias>> hashSymbol;

    private TopNRowNumberMatcher(Optional<ExpectedValueProvider<WindowNode.Specification>> specification, Optional<SymbolAlias> rowNumberSymbol, Optional<Integer> maxRowCountPerPartition, Optional<Boolean> partial, Optional<Optional<SymbolAlias>> hashSymbol) {
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.rowNumberSymbol = Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null");
        this.maxRowCountPerPartition = Objects.requireNonNull(maxRowCountPerPartition, "maxRowCountPerPartition is null");
        this.partial = Objects.requireNonNull(partial, "partial is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TopNRowNumberNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Object expected;
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TopNRowNumberNode topNRowNumberNode = (TopNRowNumberNode)node;
        if (this.specification.isPresent() && !(expected = this.specification.get().getExpectedValue(symbolAliases)).equals((Object)topNRowNumberNode.getSpecification())) {
            return MatchResult.NO_MATCH;
        }
        if (this.rowNumberSymbol.isPresent() && !(expected = this.rowNumberSymbol.get().toSymbol(symbolAliases)).equals((Object)topNRowNumberNode.getRowNumberSymbol())) {
            return MatchResult.NO_MATCH;
        }
        if (this.maxRowCountPerPartition.isPresent() && !this.maxRowCountPerPartition.get().equals(topNRowNumberNode.getMaxRowCountPerPartition())) {
            return MatchResult.NO_MATCH;
        }
        if (this.partial.isPresent() && !this.partial.get().equals(topNRowNumberNode.isPartial())) {
            return MatchResult.NO_MATCH;
        }
        if (this.hashSymbol.isPresent() && !((Optional)(expected = this.hashSymbol.get().map(alias -> alias.toSymbol(symbolAliases)))).equals(topNRowNumberNode.getHashSymbol())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("specification", this.specification).add("rowNumberSymbol", this.rowNumberSymbol).add("maxRowCountPerPartition", this.maxRowCountPerPartition).add("partial", this.partial).add("hashSymbol", this.hashSymbol).toString();
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<ExpectedValueProvider<WindowNode.Specification>> specification = Optional.empty();
        private Optional<SymbolAlias> rowNumberSymbol = Optional.empty();
        private Optional<Integer> maxRowCountPerPartition = Optional.empty();
        private Optional<Boolean> partial = Optional.empty();
        private Optional<Optional<SymbolAlias>> hashSymbol = Optional.empty();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
            this.specification = Optional.of(PlanMatchPattern.specification(partitionBy, orderBy, orderings));
            return this;
        }

        public Builder rowNumberSymbol(SymbolAlias rowNumberSymbol) {
            this.rowNumberSymbol = Optional.of(Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null"));
            return this;
        }

        public Builder maxRowCountPerPartition(int maxRowCountPerPartition) {
            this.maxRowCountPerPartition = Optional.of(maxRowCountPerPartition);
            return this;
        }

        public Builder partial(boolean partial) {
            this.partial = Optional.of(partial);
            return this;
        }

        public Builder hashSymbol(Optional<SymbolAlias> hashSymbol) {
            this.hashSymbol = Optional.of(Objects.requireNonNull(hashSymbol, "hashSymbol is null"));
            return this;
        }

        PlanMatchPattern build() {
            return PlanMatchPattern.node(TopNRowNumberNode.class, this.source).with(new TopNRowNumberMatcher(this.specification, this.rowNumberSymbol, this.maxRowCountPerPartition, this.partial, this.hashSymbol));
        }
    }
}

