/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionVerifier;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

final class UnnestMatcher
implements Matcher {
    private final List<String> replicateSymbols;
    private final List<PlanMatchPattern.UnnestMapping> unnestMappings;
    private final Optional<String> ordinalitySymbol;
    private final JoinNode.Type type;
    private final Optional<Expression> filter;

    public UnnestMatcher(List<String> replicateSymbols, List<PlanMatchPattern.UnnestMapping> unnestMappings, Optional<String> ordinalitySymbol, JoinNode.Type type, Optional<Expression> filter) {
        this.replicateSymbols = Objects.requireNonNull(replicateSymbols, "replicateSymbols is null");
        this.unnestMappings = Objects.requireNonNull(unnestMappings, "unnestMappings is null");
        this.ordinalitySymbol = Objects.requireNonNull(ordinalitySymbol, "ordinalitySymbol is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof UnnestNode)) {
            return false;
        }
        UnnestNode unnestNode = (UnnestNode)node;
        return unnestNode.getJoinType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        UnnestNode unnestNode = (UnnestNode)node;
        if (unnestNode.getReplicateSymbols().size() != this.replicateSymbols.size()) {
            return MatchResult.NO_MATCH;
        }
        if (!((ImmutableList)this.replicateSymbols.stream().map(symbolAliases::get).map(Symbol::from).collect(ImmutableList.toImmutableList())).equals((Object)unnestNode.getReplicateSymbols())) {
            return MatchResult.NO_MATCH;
        }
        if (unnestNode.getMappings().size() != this.unnestMappings.size()) {
            return MatchResult.NO_MATCH;
        }
        if (!IntStream.range(0, this.unnestMappings.size()).boxed().allMatch(index -> {
            UnnestNode.Mapping nodeMapping = (UnnestNode.Mapping)unnestNode.getMappings().get((int)index);
            PlanMatchPattern.UnnestMapping patternMapping = this.unnestMappings.get((int)index);
            return nodeMapping.getInput().toSymbolReference().equals((Object)symbolAliases.get(patternMapping.getInput())) && patternMapping.getOutputs().size() == nodeMapping.getOutputs().size();
        })) {
            return MatchResult.NO_MATCH;
        }
        if (this.ordinalitySymbol.isPresent() != unnestNode.getOrdinalitySymbol().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.type.equals((Object)unnestNode.getJoinType())) {
            return MatchResult.NO_MATCH;
        }
        if (this.filter.isPresent() != unnestNode.getFilter().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (this.filter.isEmpty()) {
            return MatchResult.match();
        }
        if (!((Boolean)new ExpressionVerifier(symbolAliases).process((Node)unnestNode.getFilter().get(), (Node)this.filter.get())).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("replicateSymbols", this.replicateSymbols).add("unnestMappings", this.unnestMappings).add("ordinalitySymbol", this.ordinalitySymbol.orElse(null)).add("filter", this.filter.orElse(null)).toString();
    }
}

