/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.MockConnectorColumnHandle;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.MockConnectorTableHandle;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableScanRedirectApplicationResult;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ApplyTableScanRedirection;
import io.prestosql.sql.planner.iterative.rule.test.RuleTester;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.TestingTransactionHandle;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestApplyTableScanRedirection {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName sourceTable = new SchemaTableName("test_schema", "test_table");
    private static final TableHandle TEST_TABLE_HANDLE = TestApplyTableScanRedirection.createTableHandle(new MockConnectorTableHandle(sourceTable));
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();
    private static final String sourceColumnNameA = "source_col_a";
    private static final ColumnHandle sourceColumnHandleA = new MockConnectorColumnHandle("source_col_a", (Type)VarcharType.VARCHAR);
    private static final String sourceColumnNameB = "source_col_b";
    private static final ColumnHandle sourceColumnHandleB = new MockConnectorColumnHandle("source_col_b", (Type)VarcharType.VARCHAR);
    private static final SchemaTableName destinationTable = new SchemaTableName("target_schema", "target_table");
    private static final String destinationColumnNameA = "destination_col_a";
    private static final ColumnHandle destinationColumnHandleA = new MockConnectorColumnHandle("destination_col_a", (Type)VarcharType.VARCHAR);
    private static final String destinationColumnNameB = "destination_col_b";
    private static final ColumnHandle destinationColumnHandleB = new MockConnectorColumnHandle("destination_col_b", (Type)VarcharType.VARCHAR);
    private static final String destinationColumnNameC = "destination_col_c";

    private static TableHandle createTableHandle(ConnectorTableHandle tableHandle) {
        return new TableHandle(new CatalogName(MOCK_CATALOG), tableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
    }

    @Test
    public void testDoesNotFire() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorFactory mockFactory = this.createMockFactory(Optional.empty());
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getMetadata())).on(p -> {
                Symbol column = p.symbol(sourceColumnNameA, (Type)VarcharType.VARCHAR);
                return p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)sourceColumnHandleA));
            }).withSession(MOCK_SESSION).doesNotFire();
        }
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)sourceColumnHandleA, (Object)destinationColumnNameA));
            MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getMetadata())).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).withSession(MOCK_SESSION).doesNotFire();
        }
    }

    @Test
    public void testMismatchedTypes() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)sourceColumnHandleA, (Object)destinationColumnNameC));
            MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
            LocalQueryRunner runner = ruleTester.getQueryRunner();
            runner.createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            TransactionBuilder.transaction((TransactionManager)runner.getTransactionManager(), (AccessControl)runner.getAccessControl()).execute(MOCK_SESSION, session -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runner.createPlan(session, "SELECT source_col_a FROM test_table", WarningCollector.NOOP)).isInstanceOf(PrestoException.class)).hasMessageMatching("Redirected column mock_catalog.target_schema.target_table.destination_col_c has type bigint, different from source column .*MockConnectorTableHandle.*source_col_a.* type: varchar"));
        }
    }

    @Test
    public void testApplyTableScanRedirection() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)sourceColumnHandleA, (Object)destinationColumnNameA));
            MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getMetadata())).on(p -> {
                Symbol column = p.symbol(sourceColumnNameA, (Type)VarcharType.VARCHAR);
                return p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)sourceColumnHandleA));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)new MockConnectorTableHandle(destinationTable)), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", (Object)Predicates.equalTo((Object)destinationColumnHandleA))));
        }
    }

    @Test
    public void testApplyTableScanRedirectionWithFilter() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)sourceColumnHandleA, (Object)destinationColumnNameA, (Object)sourceColumnHandleB, (Object)destinationColumnNameB));
            MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            ApplyTableScanRedirection applyTableScanRedirection = new ApplyTableScanRedirection(ruleTester.getMetadata());
            TupleDomain constraint = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)sourceColumnHandleA, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo"))));
            ruleTester.assertThat((Rule<?>)applyTableScanRedirection).on(p -> {
                Symbol column = p.symbol(sourceColumnNameA, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(new MockConnectorTableHandle(sourceTable, (TupleDomain<ColumnHandle>)constraint, Optional.empty())), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)sourceColumnHandleA), (TupleDomain<ColumnHandle>)constraint);
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.filter("DEST_COL = CAST('foo' AS varchar)", PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)new MockConnectorTableHandle(destinationTable)), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", (Object)Predicates.equalTo((Object)destinationColumnHandleA)))));
            ruleTester.assertThat((Rule<?>)applyTableScanRedirection).on(p -> {
                Symbol column = p.symbol(sourceColumnNameB, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(new MockConnectorTableHandle(sourceTable, (TupleDomain<ColumnHandle>)constraint, Optional.empty())), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)sourceColumnHandleB), (TupleDomain<ColumnHandle>)constraint);
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("DEST_COL_B")), PlanMatchPattern.filter("DEST_COL_A = CAST('foo' AS varchar)", PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)new MockConnectorTableHandle(destinationTable)), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_A", (Object)Predicates.equalTo((Object)destinationColumnHandleA), (Object)"DEST_COL_B", (Object)Predicates.equalTo((Object)destinationColumnHandleB))))));
        }
    }

    private MockConnectorFactory.ApplyTableScanRedirect getMockApplyRedirect(Map<ColumnHandle, String> redirectionMapping) {
        return (session, handle) -> Optional.of(new TableScanRedirectApplicationResult(new CatalogSchemaTableName(MOCK_CATALOG, destinationTable), redirectionMapping, ((MockConnectorTableHandle)handle).getConstraint().transform(MockConnectorColumnHandle.class::cast).transform(redirectionMapping::get)));
    }

    private MockConnectorFactory createMockFactory(Optional<MockConnectorFactory.ApplyTableScanRedirect> applyTableScanRedirect) {
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)sourceTable)) {
                return ImmutableList.of((Object)new ColumnMetadata(sourceColumnNameA, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(sourceColumnNameB, (Type)VarcharType.VARCHAR));
            }
            if (schemaTableName.equals((Object)destinationTable)) {
                return ImmutableList.of((Object)new ColumnMetadata(destinationColumnNameA, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(destinationColumnNameB, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(destinationColumnNameC, (Type)BigintType.BIGINT));
            }
            throw new IllegalArgumentException();
        });
        applyTableScanRedirect.ifPresent(builder::withApplyTableScanRedirect);
        return builder.build();
    }
}

