/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.type.BigintType;
import io.prestosql.sql.ExpressionTestUtils;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Map;
import org.testng.annotations.Test;

public class TestCanonicalizeExpressionRewriter {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TypeAnalyzer TYPE_ANALYZER = new TypeAnalyzer(new SqlParser(), METADATA);

    @Test
    public void testRewriteIsNotNullPredicate() {
        TestCanonicalizeExpressionRewriter.assertRewritten("x is NOT NULL", "NOT (x IS NULL)");
    }

    @Test
    public void testRewriteIfExpression() {
        TestCanonicalizeExpressionRewriter.assertRewritten("IF(x = 0, 0, 1)", "CASE WHEN x = 0 THEN 0 ELSE 1 END");
    }

    @Test
    public void testRewriteYearExtract() {
        TestCanonicalizeExpressionRewriter.assertRewritten("EXTRACT(YEAR FROM DATE '2017-07-20')", "year(DATE '2017-07-20')");
    }

    @Test
    public void testCanonicalizeArithmetic() {
        TestCanonicalizeExpressionRewriter.assertRewritten("a + 1", "a + 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 + a", "a + 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a * 1", "a * 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 * a", "a * 1");
    }

    @Test
    public void testCanonicalizeComparison() {
        TestCanonicalizeExpressionRewriter.assertRewritten("a = 1", "a = 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 = a", "a = 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a <> 1", "a <> 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 <> a", "a <> 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a > 1", "a > 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 > a", "a < 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a < 1", "a < 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 < a", "a > 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a >= 1", "a >= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 >= a", "a <= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a <= 1", "a <= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 <= a", "a >= 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("a IS DISTINCT FROM 1", "a IS DISTINCT FROM 1");
        TestCanonicalizeExpressionRewriter.assertRewritten("1 IS DISTINCT FROM a", "a IS DISTINCT FROM 1");
    }

    @Test
    public void testTypedLiteral() {
        TestCanonicalizeExpressionRewriter.assertRewritten("a = CAST(1 AS decimal(5,2))", "a = CAST(1 AS decimal(5,2))");
        TestCanonicalizeExpressionRewriter.assertRewritten("CAST(1 AS decimal(5,2)) = a", "a = CAST(1 AS decimal(5,2))");
        TestCanonicalizeExpressionRewriter.assertRewritten("a + CAST(1 AS decimal(5,2))", "a + CAST(1 AS decimal(5,2))");
        TestCanonicalizeExpressionRewriter.assertRewritten("CAST(1 AS decimal(5,2)) + a", "a + CAST(1 AS decimal(5,2))");
    }

    private static void assertRewritten(String from, String to) {
        ExpressionTestUtils.assertExpressionEquals(CanonicalizeExpressionRewriter.rewrite((Expression)PlanBuilder.expression(from), (Session)SessionTestUtils.TEST_SESSION, (Metadata)METADATA, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("x"), (Object)BigintType.BIGINT).put((Object)new Symbol("a"), (Object)BigintType.BIGINT).build())), PlanBuilder.expression(to), SymbolAliases.builder().put("x", new SymbolReference("x")).put("a", new SymbolReference("a")).build());
    }
}

