/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.rule.CanonicalizeExpressions;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import org.testng.annotations.Test;

public class TestCanonicalizeExpressions
extends BaseRuleTest {
    public TestCanonicalizeExpressions() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireForExpressionsInCanonicalForm() {
        CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions(this.tester().getMetadata(), this.tester().getTypeAnalyzer());
        this.tester().assertThat(canonicalizeExpressions.filterExpressionRewrite()).on(p -> p.filter((Expression)BooleanLiteral.FALSE_LITERAL, (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testDoesNotFireForUnfilteredJoin() {
        CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions(this.tester().getMetadata(), this.tester().getTypeAnalyzer());
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireForCanonicalExpressions() {
        CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions(this.tester().getMetadata(), this.tester().getTypeAnalyzer());
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]), (Expression)BooleanLiteral.FALSE_LITERAL, new JoinNode.EquiJoinClause[0])).doesNotFire();
    }
}

