/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ImplementFilteredAggregations;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestImplementFilteredAggregations
extends BaseRuleTest {
    public TestImplementFilteredAggregations() {
        super(new Plugin[0]);
    }

    @Test
    public void testFilterToMask() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(p.symbol("sum"), (Expression)this.functionWithFilter("sum", a, Optional.of(filter)), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(a, g, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"filter"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter("true", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"g", (Object)PlanMatchPattern.expression("g"), (Object)"filter", (Object)PlanMatchPattern.expression("filter")), PlanMatchPattern.values("a", "g", "filter")))));
    }

    @Test
    public void testCombineMaskAndFilter() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol mask = p.symbol("mask", (Type)BooleanType.BOOLEAN);
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.singleGroupingSet(g).addAggregation(p.symbol("sum"), (Expression)this.functionWithFilter("sum", a, Optional.of(filter)), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).source((PlanNode)p.values(a, g, mask, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("g"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter("true", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"g", (Object)PlanMatchPattern.expression("g"), (Object)"mask", (Object)PlanMatchPattern.expression("mask"), (Object)"filter", (Object)PlanMatchPattern.expression("filter"), (Object)"new_mask", (Object)PlanMatchPattern.expression("mask AND filter")), PlanMatchPattern.values("a", "g", "mask", "filter")))));
    }

    @Test
    public void testWithFilterPushdown() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), (Expression)this.functionWithFilter("sum", a, Optional.of(filter)), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(a, g, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"filter"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter("filter", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"g", (Object)PlanMatchPattern.expression("g"), (Object)"filter", (Object)PlanMatchPattern.expression("filter")), PlanMatchPattern.values("a", "g", "filter")))));
    }

    @Test
    public void testWithMultipleAggregations() {
        this.tester().assertThat((Rule<?>)new ImplementFilteredAggregations(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol g = p.symbol("g");
            Symbol filter = p.symbol("filter", (Type)BooleanType.BOOLEAN);
            return p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), (Expression)this.functionWithFilter("sum", a, Optional.of(filter)), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("avg"), (Expression)this.functionWithFilter("avg", a, Optional.empty()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(a, g, filter)));
        }).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("avg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"filter"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter("true", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"g", (Object)PlanMatchPattern.expression("g"), (Object)"filter", (Object)PlanMatchPattern.expression("filter")), PlanMatchPattern.values("a", "g", "filter")))));
    }

    private FunctionCall functionWithFilter(String name, Symbol argument, Optional<Symbol> filter) {
        return new FunctionCall(Optional.empty(), QualifiedName.of((String)name), Optional.empty(), filter.map(Symbol::toSymbolReference), Optional.empty(), false, Optional.empty(), (List)ImmutableList.of((Object)argument.toSymbolReference()));
    }
}

