/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.MergeIntersect;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeIntersect
extends BaseRuleTest {
    public TestMergeIntersect() {
        super(new Plugin[0]);
    }

    @Test
    public void testFlattening() {
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            IntersectNode u1 = p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            IntersectNode u2 = p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)d, (Object)a).put((Object)d, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)u2));
        }).matches(PlanMatchPattern.intersect(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.values("a"), PlanMatchPattern.values("b")));
    }

    @Test
    public void testMixedFlattening() {
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            IntersectNode u1 = p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)p.values(1, d)));
        }).matches(PlanMatchPattern.intersect(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.values("d")));
    }

    @Test
    public void testNotFlattening() {
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
        }).doesNotFire();
    }

    @Test
    public void testQuantifiers() {
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, true, true, true)).matches(PlanMatchPattern.intersect(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, true, true, false)).matches(PlanMatchPattern.intersect(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, true, false, true)).matches(PlanMatchPattern.intersect(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, false, true, true)).matches(PlanMatchPattern.intersect(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, true, false, false)).matches(PlanMatchPattern.intersect(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, false, false, true)).matches(PlanMatchPattern.intersect(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, false, true, false)).matches(PlanMatchPattern.intersect(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
        this.tester().assertThat((Rule<?>)new MergeIntersect()).on(p -> this.buildNestedIntersect((PlanBuilder)p, false, false, false)).matches(PlanMatchPattern.intersect(false, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("v_3"), PlanMatchPattern.values("v_4")));
    }

    private PlanNode buildNestedIntersect(PlanBuilder builder, boolean lefSourceDistinct, boolean rightSourceDistinct, boolean parentDistinct) {
        Symbol v1 = builder.symbol("v_1");
        Symbol v2 = builder.symbol("v_2");
        Symbol v3 = builder.symbol("v_3");
        Symbol v4 = builder.symbol("v_4");
        Symbol a = builder.symbol("a");
        Symbol b = builder.symbol("b");
        Symbol c = builder.symbol("c");
        IntersectNode child1 = builder.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)a, (Object)v1, (Object)a, (Object)v2), (List<PlanNode>)ImmutableList.of((Object)builder.values(v1), (Object)builder.values(v2)), lefSourceDistinct);
        IntersectNode child2 = builder.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)b, (Object)v3, (Object)b, (Object)v4), (List<PlanNode>)ImmutableList.of((Object)builder.values(v3), (Object)builder.values(v4)), rightSourceDistinct);
        return builder.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)c, (Object)a, (Object)c, (Object)b), (List<PlanNode>)ImmutableList.of((Object)child1, (Object)child2), parentDistinct);
    }
}

