/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.MergeLimitOverProjectWithSort;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestMergeLimitOverProjectWithSort
extends BaseRuleTest {
    public TestMergeLimitOverProjectWithSort() {
        super(new Plugin[0]);
    }

    @Test
    public void testMergeLimitOverProjectWithSort() {
        this.tester().assertThat((Rule<?>)new MergeLimitOverProjectWithSort()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.limit(1L, (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)new ExpressionMatcher("b")), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void doNotMergeLimitWithTies() {
        this.tester().assertThat((Rule<?>)new MergeLimitOverProjectWithSort()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)b), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.sort((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a, b))));
        }).doesNotFire();
    }
}

