/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.MergeLimitWithDistinct;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeLimitWithDistinct
extends BaseRuleTest {
    public TestMergeLimitWithDistinct() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new MergeLimitWithDistinct()).on(p -> p.limit(1L, (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(p.symbol("foo")).source((PlanNode)p.values(p.symbol("foo")))))).matches(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new MergeLimitWithDistinct()).on(p -> p.limit(1L, (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.expression("count(foo)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergeLimitWithDistinct()).on(p -> p.limit(1L, (PlanNode)p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).doesNotFire();
    }

    @Test
    public void testDoNotMergeLimitWithTies() {
        this.tester().assertThat((Rule<?>)new MergeLimitWithDistinct()).on(p -> {
            Symbol foo = p.symbol("foo");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)foo), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(foo).source((PlanNode)p.values(foo))));
        }).doesNotFire();
    }
}

