/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneApplyCorrelation;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneApplyCorrelation
extends BaseRuleTest {
    public TestPruneApplyCorrelation() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneCorrelationSymbolNotReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneApplyCorrelation()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(a, inputSymbol), (PlanNode)p.values(subquerySymbol));
        }).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("subquery_symbol"))), PlanMatchPattern.values("a", "input_symbol"), PlanMatchPattern.values("subquery_symbol")));
    }

    @Test
    public void testAllCorrelationSymbolsReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneApplyCorrelation()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(a, inputSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)inputSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol)));
        }).doesNotFire();
    }
}

