/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneCorrelatedJoinCorrelation;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import org.testng.annotations.Test;

public class TestPruneCorrelatedJoinCorrelation
extends BaseRuleTest {
    public TestPruneCorrelatedJoinCorrelation() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneCorrelationSymbolNotReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinCorrelation()).on(p -> {
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(inputSymbol), (PlanNode)p.values(subquerySymbol));
        }).matches(PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of(), PlanMatchPattern.values("input_symbol"), PlanMatchPattern.values("subquery_symbol")));
    }

    @Test
    public void testAllCorrelationSymbolsReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneCorrelatedJoinCorrelation()).on(p -> {
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(inputSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)inputSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol)));
        }).doesNotFire();
    }
}

