/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneDeleteSourceColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneDeleteSourceColumns
extends BaseRuleTest {
    public TestPruneDeleteSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneInputColumn() {
        this.tester().assertThat((Rule<?>)new PruneDeleteSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowId = p.symbol("row_id");
            Symbol partialRows = p.symbol("partial_rows");
            Symbol fragment = p.symbol("fragment");
            return p.delete(new SchemaTableName("schema", "table"), (PlanNode)p.values(a, rowId), rowId, (List<Symbol>)ImmutableList.of((Object)partialRows, (Object)fragment));
        }).matches(PlanMatchPattern.node(DeleteNode.class, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_id", (Object)PlanMatchPattern.expression("row_id")), PlanMatchPattern.values("a", "row_id"))));
    }

    @Test
    public void testDoNotPruneRowId() {
        this.tester().assertThat((Rule<?>)new PruneDeleteSourceColumns()).on(p -> {
            Symbol rowId = p.symbol("row_id");
            Symbol partialRows = p.symbol("partial_rows");
            Symbol fragment = p.symbol("fragment");
            return p.delete(new SchemaTableName("schema", "table"), (PlanNode)p.values(rowId), rowId, (List<Symbol>)ImmutableList.of((Object)partialRows, (Object)fragment));
        }).doesNotFire();
    }
}

