/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneExplainAnalyzeSourceColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.ExplainAnalyzeNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneExplainAnalyzeSourceColumns
extends BaseRuleTest {
    public TestPruneExplainAnalyzeSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneExplainAnalyzeSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.explainAnalyzeNode(p.symbol("query plan", (Type)VarcharType.VARCHAR), (List<Symbol>)ImmutableList.of((Object)b), (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.node(ExplainAnalyzeNode.class, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneExplainAnalyzeSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.explainAnalyzeNode(p.symbol("query plan", (Type)VarcharType.VARCHAR), (List<Symbol>)ImmutableList.of((Object)a, (Object)b), (PlanNode)p.values(a, b));
        }).doesNotFire();
    }
}

