/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushOffsetThroughProject;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushOffsetThroughProject
extends BaseRuleTest {
    public TestPushOffsetThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownOffsetNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushOffsetThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.offset(5L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(new Symbol[0])));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.offset(5L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testDoNotPushdownOffsetThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushOffsetThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.offset(5L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

