/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.SortOrder;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.TopNRowNumberSymbolMatcher;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushPredicateThroughProjectIntoWindow;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushPredicateThroughProjectIntoWindow
extends BaseRuleTest {
    public TestPushPredicateThroughProjectIntoWindow() {
        super(new Plugin[0]);
    }

    @Test
    public void testRowNumberSymbolPruned() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getMetadata(), this.tester().getQueryRunner().getTypeOperators())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("a = 1"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)this.rowNumberFunction()), (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNoUpperBoundForRowNumberSymbol() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getMetadata(), this.tester().getQueryRunner().getTypeOperators())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("a = 1"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)this.rowNumberFunction()), (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNonPositiveUpperBoundForRowNumberSymbol() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getMetadata(), this.tester().getQueryRunner().getTypeOperators())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("a = 1 AND row_number < -10"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, rowNumber}), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)this.rowNumberFunction()), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.values("a", "row_number"));
    }

    @Test
    public void testPredicateNotSatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getMetadata(), this.tester().getQueryRunner().getTypeOperators())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number > 2 AND row_number < 5"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)this.rowNumberFunction()), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter("row_number > 2 AND row_number < 5", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.topNRowNumber(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).maxRowCountPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher()))));
    }

    @Test
    public void testPredicateSatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getMetadata(), this.tester().getQueryRunner().getTypeOperators())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number < 5"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)this.rowNumberFunction()), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.topNRowNumber(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).maxRowCountPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher())));
    }

    @Test
    public void testPredicatePartiallySatisfied() {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getMetadata(), this.tester().getQueryRunner().getTypeOperators())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number < 5 AND a > 0"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber, a}), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)this.rowNumberFunction()), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter("a > 0", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number"), (Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.topNRowNumber(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).maxRowCountPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher()))));
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getMetadata(), this.tester().getQueryRunner().getTypeOperators())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumber = p.symbol("row_number");
            return p.filter(PlanBuilder.expression("row_number < 5 AND row_number % 2 = 0"), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{rowNumber}), (PlanNode)p.window(new WindowNode.Specification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumber, (Object)this.rowNumberFunction()), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter("row_number % 2 = 0", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row_number", (Object)PlanMatchPattern.expression("row_number")), PlanMatchPattern.topNRowNumber(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).maxRowCountPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("row_number", (RvalueMatcher)new TopNRowNumberSymbolMatcher()))));
    }

    private WindowNode.Function rowNumberFunction() {
        return new WindowNode.Function(this.tester().getMetadata().resolveFunction(QualifiedName.of((String)"row_number"), TypeSignatureProvider.fromTypes((Type[])new Type[0])), (List)ImmutableList.of(), new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), false);
    }
}

