/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.MockConnectorTableHandle;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.spi.connector.Assignment;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.expression.Constant;
import io.prestosql.spi.expression.FieldDereference;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.ConnectorExpressionTranslator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.iterative.rule.test.RuleTester;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingSession;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPushProjectionIntoTableScan {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName TEST_SCHEMA_TABLE = new SchemaTableName("test_schema", "test_table");
    private static final Type ROW_TYPE = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)));
    private static final TableHandle TEST_TABLE_HANDLE = TestPushProjectionIntoTableScan.createTableHandle("test_schema", "test_table");
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();

    @Test
    public void testDoesNotFire() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            String columnName = "input_column";
            Type columnType = ROW_TYPE;
            ColumnHandle inputColumnHandle = TestPushProjectionIntoTableScan.column(columnName, columnType);
            MockConnectorFactory factory = this.createMockFactory((Map<String, ColumnHandle>)ImmutableMap.of((Object)columnName, (Object)inputColumnHandle), Optional.empty());
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)factory, (Map)ImmutableMap.of());
            PushProjectionIntoTableScan optimizer = new PushProjectionIntoTableScan(ruleTester.getMetadata(), new TypeAnalyzer(new SqlParser(), ruleTester.getMetadata()));
            ruleTester.assertThat((Rule<?>)optimizer).on(p -> {
                Symbol symbol = p.symbol(columnName, columnType);
                return p.project(Assignments.of((Symbol)p.symbol("symbol_dereference", (Type)BigintType.BIGINT), (Expression)new DereferenceExpression((Expression)symbol.toSymbolReference(), new Identifier("a"))), (PlanNode)p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)inputColumnHandle)));
            }).withSession(MOCK_SESSION).doesNotFire();
        }
    }

    @Test
    public void testPushProjection() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            String columnName = "col0";
            Type columnType = ROW_TYPE;
            Symbol baseColumn = new Symbol(columnName);
            TpchColumnHandle columnHandle = new TpchColumnHandle(columnName, columnType);
            MockConnectorFactory factory = this.createMockFactory((Map<String, ColumnHandle>)ImmutableMap.of((Object)columnName, (Object)columnHandle), Optional.of(this::mockApplyProjection));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)factory, (Map)ImmutableMap.of());
            Metadata metadata = ruleTester.getMetadata();
            TypeAnalyzer typeAnalyzer = new TypeAnalyzer(new SqlParser(), metadata);
            PushProjectionIntoTableScan optimizer = new PushProjectionIntoTableScan(metadata, typeAnalyzer);
            Symbol identity = new Symbol("symbol_identity");
            Symbol dereference = new Symbol("symbol_dereference");
            Symbol constant = new Symbol("symbol_constant");
            ImmutableMap types = ImmutableMap.of((Object)baseColumn, (Object)ROW_TYPE, (Object)identity, (Object)ROW_TYPE, (Object)dereference, (Object)BigintType.BIGINT, (Object)constant, (Object)BigintType.BIGINT);
            ImmutableMap inputProjections = ImmutableMap.of((Object)identity, (Object)baseColumn.toSymbolReference(), (Object)dereference, (Object)new DereferenceExpression((Expression)baseColumn.toSymbolReference(), new Identifier("a")), (Object)constant, (Object)new LongLiteral("5"));
            ImmutableMap connectorNames = (ImmutableMap)inputProjections.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ConnectorExpression)ConnectorExpressionTranslator.translate((Session)MOCK_SESSION, (Expression)((Expression)e.getValue()), (TypeAnalyzer)typeAnalyzer, (TypeProvider)TypeProvider.viewOf((Map)types)).get()).toString()));
            ImmutableMap newNames = ImmutableMap.of((Object)identity, (Object)("projected_variable_" + (String)connectorNames.get((Object)identity)), (Object)dereference, (Object)("projected_dereference_" + (String)connectorNames.get((Object)dereference)), (Object)constant, (Object)("projected_constant_" + (String)connectorNames.get((Object)constant)));
            ruleTester.assertThat((Rule<?>)optimizer).on(arg_0 -> TestPushProjectionIntoTableScan.lambda$testPushProjection$2(columnName, columnType, identity, types, dereference, constant, inputProjections, (ColumnHandle)columnHandle, arg_0)).withSession(MOCK_SESSION).matches(PlanMatchPattern.project((Map)newNames.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((Symbol)e.getKey()).getName(), e -> PlanMatchPattern.expression((Expression)TestPushProjectionIntoTableScan.symbolReference((String)e.getValue())))), PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)TestPushProjectionIntoTableScan.createTableHandle(TEST_SCHEMA, "projected_test_table").getConnectorHandle()), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map)newNames.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, e -> Predicates.equalTo((Object)TestPushProjectionIntoTableScan.column((String)e.getValue(), (Type)types.get(e.getKey()))))))));
        }
    }

    private MockConnectorFactory createMockFactory(Map<String, ColumnHandle> assignments, Optional<MockConnectorFactory.ApplyProjection> applyProjection) {
        List metadata = (List)assignments.entrySet().stream().map(entry -> new ColumnMetadata((String)entry.getKey(), ((TpchColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)TEST_SCHEMA)).withListTables((connectorSession, schema) -> TEST_SCHEMA.equals(schema) ? ImmutableList.of((Object)TEST_SCHEMA_TABLE) : ImmutableList.of()).withGetColumns(schemaTableName -> metadata);
        if (applyProjection.isPresent()) {
            builder = builder.withApplyProjection(applyProjection.get());
        }
        return builder.build();
    }

    private Optional<ProjectionApplicationResult<ConnectorTableHandle>> mockApplyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        SchemaTableName inputSchemaTableName = ((MockConnectorTableHandle)tableHandle).getTableName();
        SchemaTableName projectedTableName = new SchemaTableName(inputSchemaTableName.getSchemaName(), "projected_" + inputSchemaTableName.getTableName());
        MockConnectorTableHandle newTableHandle = new MockConnectorTableHandle(projectedTableName);
        ImmutableList.Builder outputExpressions = ImmutableList.builder();
        ImmutableList.Builder outputAssignments = ImmutableList.builder();
        for (ConnectorExpression projection : projections) {
            String variablePrefix;
            if (projection instanceof Variable) {
                variablePrefix = "projected_variable_";
            } else if (projection instanceof FieldDereference) {
                variablePrefix = "projected_dereference_";
            } else if (projection instanceof Constant) {
                variablePrefix = "projected_constant_";
            } else {
                throw new UnsupportedOperationException();
            }
            String newVariableName = variablePrefix + projection.toString();
            Variable newVariable = new Variable(newVariableName, projection.getType());
            TpchColumnHandle newColumnHandle = new TpchColumnHandle(newVariableName, projection.getType());
            outputExpressions.add((Object)newVariable);
            outputAssignments.add((Object)new Assignment(newVariableName, (ColumnHandle)newColumnHandle, projection.getType()));
        }
        return Optional.of(new ProjectionApplicationResult((Object)newTableHandle, (List)outputExpressions.build(), (List)outputAssignments.build()));
    }

    private static TableHandle createTableHandle(String schemaName, String tableName) {
        return new TableHandle(new CatalogName(MOCK_CATALOG), (ConnectorTableHandle)new MockConnectorTableHandle(new SchemaTableName(schemaName, tableName)), new ConnectorTransactionHandle(){}, Optional.empty());
    }

    private static SymbolReference symbolReference(String name) {
        return new SymbolReference(name);
    }

    private static ColumnHandle column(String name, Type type) {
        return new TpchColumnHandle(name, type);
    }

    private static /* synthetic */ PlanNode lambda$testPushProjection$2(String columnName, Type columnType, Symbol identity, ImmutableMap types, Symbol dereference, Symbol constant, ImmutableMap inputProjections, ColumnHandle columnHandle, PlanBuilder p) {
        Symbol columnSymbol = p.symbol(columnName, columnType);
        p.symbol(identity.getName(), (Type)types.get((Object)identity));
        p.symbol(dereference.getName(), (Type)types.get((Object)dereference));
        p.symbol(constant.getName(), (Type)types.get((Object)constant));
        return p.project(new Assignments((Map)inputProjections), (PlanNode)p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)columnSymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnSymbol, (Object)columnHandle)));
    }
}

