/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.SortOrder;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushProjectionThroughExchange;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushProjectionThroughExchange
extends BaseRuleTest {
    public TestPushProjectionThroughExchange() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireNoExchange() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)new LongLiteral("3")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testDoesNotFireNarrowingProjection() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.project(Assignments.builder().put(a, (Expression)a.toSymbolReference()).put(b, (Expression)b.toSymbolReference()).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, c)).addInputsSet(a, b, c).singleDistributionPartitioningScheme(a, b, c)));
        }).doesNotFire();
    }

    @Test
    public void testSimpleMultipleInputs() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol c2 = p.symbol("c2");
            Symbol x = p.symbol("x");
            return p.project(Assignments.of((Symbol)x, (Expression)new LongLiteral("3"), (Symbol)c2, (Expression)new SymbolReference("c")), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addSource((PlanNode)p.values(b)).addInputsSet(a).addInputsSet(b).singleDistributionPartitioningScheme(c)));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("x1", (RvalueMatcher)PlanMatchPattern.expression("3")), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"))).withAlias("x2", (RvalueMatcher)PlanMatchPattern.expression("3"))).withAlias("x1").withAlias("x2"));
    }

    @Test
    public void testHashMapping() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol h1 = p.symbol("h_1");
            Symbol c = p.symbol("c");
            Symbol h = p.symbol("h");
            Symbol cTimes5 = p.symbol("c_times_5");
            return p.project(Assignments.of((Symbol)cTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("c"), (Expression)new LongLiteral("5"))), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, h1)).addInputsSet(a, h1).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)c, (Object)h), (List<Symbol>)ImmutableList.of((Object)c), h)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"h_1", (Object)PlanMatchPattern.expression("h_1"), (Object)"a_times_5", (Object)PlanMatchPattern.expression("a * 5")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"h_1"))))));
    }

    @Test
    public void testSkipIdentityProjectionIfOutputPresent() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol aTimes5 = p.symbol("a_times_5");
            return p.project(Assignments.of((Symbol)aTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral("5")), (Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)a), (List<Symbol>)ImmutableList.of((Object)a))));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression("a"), (Object)"a_times_5", (Object)PlanMatchPattern.expression("a * 5")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol bTimes5 = p.symbol("b_times_5");
            Symbol b = p.symbol("b");
            return p.project(Assignments.of((Symbol)bTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new LongLiteral("5")), (Symbol)b, (Expression)b.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)b), (List<Symbol>)ImmutableList.of((Object)b))));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression("a"), (Object)"a_times_5", (Object)PlanMatchPattern.expression("a * 5")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
    }

    @Test
    public void testDoNotSkipIdentityProjectionIfOutputAbsent() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol aTimes5 = p.symbol("a_times_5");
            return p.project(Assignments.of((Symbol)aTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral("5")), (Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).singleDistributionPartitioningScheme(a)));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression("a"), (Object)"a_times_5", (Object)PlanMatchPattern.expression("a * 5")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol bTimes5 = p.symbol("b_times_5");
            Symbol b = p.symbol("b");
            return p.project(Assignments.of((Symbol)bTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new LongLiteral("5")), (Symbol)b, (Expression)b.toSymbolReference()), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a)).addInputsSet(a).singleDistributionPartitioningScheme(b)));
        }).matches(PlanMatchPattern.exchange(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a_0", (Object)PlanMatchPattern.expression("a"), (Object)"a_times_5", (Object)PlanMatchPattern.expression("a * 5")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a")))));
    }

    @Test
    public void testPartitioningColumnAndHashWithoutIdentityMappingInProjection() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol h = p.symbol("h");
            Symbol aTimes5 = p.symbol("a_times_5");
            Symbol bTimes5 = p.symbol("b_times_5");
            Symbol hTimes5 = p.symbol("h_times_5");
            return p.project(Assignments.builder().put(aTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral("5"))).put(bTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new LongLiteral("5"))).put(hTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("h"), (Expression)new LongLiteral("5"))).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, h)).addInputsSet(a, b, h).fixedHashDistributionParitioningScheme((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)h), (List<Symbol>)ImmutableList.of((Object)b), h)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"h"))).withNumberOfOutputColumns(5).withAlias("b", (RvalueMatcher)PlanMatchPattern.expression("b")).withAlias("h", (RvalueMatcher)PlanMatchPattern.expression("h")).withAlias("a_times_5", (RvalueMatcher)PlanMatchPattern.expression("a * 5")).withAlias("b_times_5", (RvalueMatcher)PlanMatchPattern.expression("b * 5")).withAlias("h_times_5", (RvalueMatcher)PlanMatchPattern.expression("h * 5")))).withNumberOfOutputColumns(3).withExactOutputs("a_times_5", "b_times_5", "h_times_5"));
    }

    @Test
    public void testOrderingColumnsArePreserved() {
        this.tester().assertThat((Rule<?>)new PushProjectionThroughExchange()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol h = p.symbol("h");
            Symbol aTimes5 = p.symbol("a_times_5");
            Symbol bTimes5 = p.symbol("b_times_5");
            Symbol hTimes5 = p.symbol("h_times_5");
            Symbol sortSymbol = p.symbol("sortSymbol");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)sortSymbol), (Map)ImmutableMap.of((Object)sortSymbol, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.project(Assignments.builder().put(aTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("a"), (Expression)new LongLiteral("5"))).put(bTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new LongLiteral("5"))).put(hTimes5, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("h"), (Expression)new LongLiteral("5"))).build(), (PlanNode)p.exchange(e -> e.addSource((PlanNode)p.values(a, b, h, sortSymbol)).addInputsSet(a, b, h, sortSymbol).singleDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)h, (Object)sortSymbol)).orderingScheme(orderingScheme)));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("sortSymbol", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"h", (Object)"sortSymbol"))).withNumberOfOutputColumns(4).withAlias("a_times_5", (RvalueMatcher)PlanMatchPattern.expression("a * 5")).withAlias("b_times_5", (RvalueMatcher)PlanMatchPattern.expression("b * 5")).withAlias("h_times_5", (RvalueMatcher)PlanMatchPattern.expression("h * 5")).withAlias("sortSymbol", (RvalueMatcher)PlanMatchPattern.expression("sortSymbol")))).withNumberOfOutputColumns(3).withExactOutputs("a_times_5", "b_times_5", "h_times_5"));
    }
}

