/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.metadata.AbstractMockMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.SampleType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushSampleIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushSampleIntoTableScan
extends BaseRuleTest {
    public TestPushSampleIntoTableScan() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushSampleIntoTableScan((Metadata)new TestMetadata(false))).on(p -> p.sample(0.15, SampleNode.Type.SYSTEM, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))).doesNotFire();
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new PushSampleIntoTableScan((Metadata)new TestMetadata(true))).on(p -> p.sample(0.15, SampleNode.Type.SYSTEM, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))).matches(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]));
    }

    private static class TestMetadata
    extends AbstractMockMetadata {
        private boolean samplePushdown;

        public TestMetadata(boolean samplePushdown) {
            this.samplePushdown = samplePushdown;
        }

        @Override
        public Optional<TableHandle> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
            if (this.samplePushdown) {
                return Optional.of(table);
            }
            return Optional.empty();
        }
    }
}

