/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.MockConnectorTableHandle;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TopNApplicationResult;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushTopNIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.test.RuleTester;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.testing.TestingSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPushTopNIntoTableScan {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName TEST_SCHEMA_TABLE = new SchemaTableName("test_schema", "test_table");
    private static final TableHandle TEST_TABLE_HANDLE = TestPushTopNIntoTableScan.createTableHandle(new MockConnectorTableHandle(new SchemaTableName("test_schema", "test_table")));
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();
    private static final String dimensionName = "dimension";
    private static final ColumnHandle dimensionColumn = new TpchColumnHandle("dimension", (Type)VarcharType.VARCHAR);
    private static final String metricName = "metric";
    private static final ColumnHandle metricColumn = new TpchColumnHandle("metric", (Type)BigintType.BIGINT);
    private static final ImmutableMap<String, ColumnHandle> assignments = ImmutableMap.of((Object)"dimension", (Object)dimensionColumn, (Object)"metric", (Object)metricColumn);

    private static TableHandle createTableHandle(ConnectorTableHandle tableHandle) {
        return new TableHandle(new CatalogName(MOCK_CATALOG), tableHandle, new ConnectorTransactionHandle(){}, Optional.empty());
    }

    @Test
    public void testDoesNotFire() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.empty());
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), (PlanNode)p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).doesNotFire();
        }
    }

    @Test
    public void testPushTopNIntoTableScan() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorTableHandle connectorHandle = new MockConnectorTableHandle(TEST_SCHEMA_TABLE);
            MockConnectorFactory.ApplyTopN applyTopN = (session, handle, topNCount, sortItems, tableAssignments) -> Optional.of(new TopNApplicationResult((Object)connectorHandle, true));
            MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.of(applyTopN));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), (PlanNode)p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)connectorHandle), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), new HashMap<String, Predicate<ColumnHandle>>()));
        }
    }

    @Test
    public void testPushTopNIntoTableScanPartial() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            MockConnectorTableHandle connectorHandle = new MockConnectorTableHandle(TEST_SCHEMA_TABLE);
            MockConnectorFactory.ApplyTopN applyTopN = (session, handle, topNCount, sortItems, tableAssignments) -> Optional.of(new TopNApplicationResult((Object)connectorHandle, false));
            MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.of(applyTopN));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)mockFactory, (Map)ImmutableMap.of());
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), (PlanNode)p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort(dimensionName, SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.FINAL, PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)connectorHandle), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)dimensionName, (Object)Predicates.equalTo((Object)dimensionColumn), (Object)metricName, (Object)Predicates.equalTo((Object)metricColumn)))));
        }
    }

    private MockConnectorFactory createMockFactory(Map<String, ColumnHandle> assignments, Optional<MockConnectorFactory.ApplyTopN> applyTopN) {
        List metadata = (List)assignments.entrySet().stream().map(entry -> new ColumnMetadata((String)entry.getKey(), ((TpchColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)TEST_SCHEMA)).withListTables((connectorSession, schema) -> TEST_SCHEMA.equals(schema) ? ImmutableList.of((Object)TEST_SCHEMA_TABLE) : ImmutableList.of()).withGetColumns(schemaTableName -> metadata);
        if (applyTopN.isPresent()) {
            builder = builder.withApplyTopN(applyTopN.get());
        }
        return builder.build();
    }
}

