/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushTopNThroughOuterJoin;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.tree.SortItem;
import java.util.List;
import org.testng.annotations.Test;

public class TestPushTopNThroughOuterJoin
extends BaseRuleTest {
    public TestPushTopNThroughOuterJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushTopNThroughLeftJoin() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("leftKey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey")));
    }

    @Test
    public void testPushTopNThroughRightJoin() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)rightKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.values("leftKey"), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("rightKey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.values("rightKey"))));
    }

    @Test
    public void testFullJoin() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)rightKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushTopNWhenSymbolsFromBothSources() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey, (Object)rightKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushWhenAlreadyLimited() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.PARTIAL, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.limit(1L, (PlanNode)p.values(5, leftKey)), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushWhenStepNotPartial() {
        this.tester().assertThat((Rule<?>)new PushTopNThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)leftKey), TopNNode.Step.FINAL, (PlanNode)p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }
}

