/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantLimit;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRemoveRedundantLimit
extends BaseRuleTest {
    public TestRemoveRedundantLimit() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(10L, (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.expression("count(foo)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testRemoveLimitWithTies() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> {
            Symbol c = p.symbol("c");
            return p.limit(10L, (List<Symbol>)ImmutableList.of((Object)c), (PlanNode)p.values(5, c));
        }).matches(PlanMatchPattern.values("c"));
    }

    @Test
    public void testForZeroLimit() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(0L, (PlanNode)p.filter(PlanBuilder.expression("b > 5"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1", "10"), PlanBuilder.expressions("2", "11")))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantLimit()).on(p -> p.limit(10L, (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.expression("count(foo)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("foo")).source((PlanNode)p.values(20, p.symbol("foo")))))).doesNotFire();
    }
}

