/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantSort;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestRemoveRedundantSort
extends BaseRuleTest {
    public TestRemoveRedundantSort() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantSort()).on(p -> p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.expression("count(foo)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().source((PlanNode)p.values(p.symbol("foo")))))).matches(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testForZeroCardinality() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantSort()).on(p -> p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.values(p.symbol("foo")))).matches(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]));
    }

    @Test
    public void doesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantSort()).on(p -> p.sort((List<Symbol>)ImmutableList.of((Object)p.symbol("c")), (PlanNode)p.aggregation(builder -> builder.addAggregation(p.symbol("c"), PlanBuilder.expression("count(foo)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("foo")).source((PlanNode)p.values(20, p.symbol("foo")))))).doesNotFire();
    }
}

