/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.ReorderJoins;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.iterative.rule.test.RuleAssert;
import io.prestosql.sql.planner.iterative.rule.test.RuleTester;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.QualifiedName;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestReorderJoins {
    private RuleTester tester;
    private final Metadata metadata = MetadataManager.createTestMetadataManager();

    @BeforeClass
    public void setUp() {
        this.tester = RuleTester.defaultRuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of((Object)"join_distribution_type", (Object)FeaturesConfig.JoinDistributionType.AUTOMATIC.name(), (Object)"join_reordering_strategy", (Object)FeaturesConfig.JoinReorderingStrategy.AUTOMATIC.name()), Optional.of(4));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test
    public void testKeepsOutputSymbols() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1"), p.symbol("A2")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A2")), (List<Symbol>)ImmutableList.of(), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(5000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0), (Object)new Symbol("A2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).withExactOutputs("A2"));
    }

    @Test
    public void testReplicatesAndFlipsWhenOneTableMuchSmaller() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        this.assertReorderJoins().setSystemProperty("join_max_broadcast_table_size", "1PB").on(arg_0 -> TestReorderJoins.lambda$testReplicatesAndFlipsWhenOneTableMuchSmaller$1((Type)symbolType, arg_0)).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenRequiredBySession() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        this.assertReorderJoins().on(arg_0 -> TestReorderJoins.lambda$testRepartitionsWhenRequiredBySession$2((Type)symbolType, arg_0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionsWhenBothTablesEqual() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesUnrestrictedWhenRequiredBySession() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).setSystemProperty("join_max_broadcast_table_size", "1kB").setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatedScalarJoinEvenWhereSessionRequiresRepartitioned() {
        PlanMatchPattern expectedPlan = PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)));
        PlanNodeStatsEstimate valuesA = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        PlanNodeStatsEstimate valuesB = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B1"), p.symbol("A1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), Optional.empty())).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).matches(expectedPlan);
    }

    @Test
    public void testDoesNotFireForCrossJoin() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoStats() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of(), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).doesNotFire();
    }

    @Test
    public void testDoesNotFireForNonDeterministicFilter() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)p.symbol("A1").toSymbolReference(), (Expression)new FunctionCallBuilder(this.tester.getMetadata()).setName(QualifiedName.of((String)"random")).build())))).doesNotFire();
    }

    @Test
    public void testPredicatesPushedDown() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1"), p.symbol("B2")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1"), (Object)p.symbol("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B2"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("A1").toSymbolReference(), (Expression)p.symbol("B1").toSymbolReference())))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0), (Object)new Symbol("B2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.values("B1", "B2"))));
    }

    @Test
    public void testPushesProjectionsThroughJoin() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("P1"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)p.symbol("B1").toSymbolReference()), (Symbol)p.symbol("P2"), (Expression)p.symbol("A1").toSymbolReference()), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("P1"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("P1")), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("P2").toSymbolReference(), (Expression)p.symbol("C1").toSymbolReference())))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "P1")), PlanMatchPattern.values("C1"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("P2", "P1")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"P2", (Object)PlanMatchPattern.expression("A1")), PlanMatchPattern.values("A1")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"P1", (Object)PlanMatchPattern.expression("-(B1)")), PlanMatchPattern.values("B1")))));
    }

    @Test
    public void testDoesNotPushProjectionThroughJoinIfTooExpensive() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("P1"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)p.symbol("B1").toSymbolReference())), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("P1"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("P1")), (List<Symbol>)ImmutableList.of(), Optional.empty())).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "P1")), PlanMatchPattern.values("C1"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"P1", (Object)PlanMatchPattern.expression("-(B1)")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.values("B1")))));
    }

    @Test
    public void testSmallerJoinFirst() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1"), p.symbol("B2")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1"), (Object)p.symbol("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B2"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("A1").toSymbolReference(), (Expression)p.symbol("B1").toSymbolReference())))).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(40.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0), (Object)new Symbol("B2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(99.0, 199.0, 0.0, 100.0, 100.0))).build()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), PlanMatchPattern.values("A1"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("C1", "B2")), PlanMatchPattern.values("C1"), PlanMatchPattern.values("B1", "B2"))));
    }

    @Test
    public void testReplicatesWhenNotRestricted() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").on(arg_0 -> TestReorderJoins.lambda$testReplicatesWhenNotRestricted$14((Type)symbolType, aRows, bRows, arg_0)).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").on(arg_0 -> TestReorderJoins.lambda$testReplicatesWhenNotRestricted$15((Type)symbolType, aRows, bRows, arg_0)).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReorderAndReplicate() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10;
        int bRows = 10000;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "10MB").on(arg_0 -> TestReorderJoins.lambda$testReorderAndReplicate$16((Type)symbolType, aRows, bRows, arg_0)).overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    private RuleAssert assertReorderJoins() {
        return this.tester.assertThat((Rule<?>)new ReorderJoins(this.metadata, new CostComparator(1.0, 1.0, 1.0)));
    }

    private static /* synthetic */ PlanNode lambda$testReorderAndReplicate$16(Type symbolType, int aRows, int bRows, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testReplicatesWhenNotRestricted$15(Type symbolType, int aRows, int bRows, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testReplicatesWhenNotRestricted$14(Type symbolType, int aRows, int bRows, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testRepartitionsWhenRequiredBySession$2(Type symbolType, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testReplicatesAndFlipsWhenOneTableMuchSmaller$1(Type symbolType, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }
}

