/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.iterative.rule.SimplifyExpressions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimplifyExpressions {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final LiteralEncoder LITERAL_ENCODER = new LiteralEncoder(METADATA);

    @Test
    public void testPushesDownNegations() {
        TestSimplifyExpressions.assertSimplifies("NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT X", "X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X");
        TestSimplifyExpressions.assertSimplifies("NOT (X > Y)", "X <= Y");
        TestSimplifyExpressions.assertSimplifies("NOT (X > (NOT NOT Y))", "X <= Y");
        TestSimplifyExpressions.assertSimplifies("X > (NOT NOT Y)", "X > Y");
        TestSimplifyExpressions.assertSimplifies("NOT (X AND Y AND (NOT (Z OR V)))", "(NOT X) OR (NOT Y) OR (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (NOT (Z OR V)))", "(NOT X) AND (NOT Y) AND (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (Z OR V))", "(NOT X) AND (NOT Y) AND ((NOT Z) AND (NOT V))");
        TestSimplifyExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)");
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyExpressions.assertSimplifies("X AND Y", "X AND Y");
        TestSimplifyExpressions.assertSimplifies("X OR Y", "X OR Y");
        TestSimplifyExpressions.assertSimplifies("X AND X", "X");
        TestSimplifyExpressions.assertSimplifies("X OR X", "X");
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Y)", "X OR Y");
        TestSimplifyExpressions.assertSimplifies("(A AND V) OR V", "V");
        TestSimplifyExpressions.assertSimplifies("(A OR V) AND V", "V");
        TestSimplifyExpressions.assertSimplifies("(A OR B OR C) AND (A OR B)", "A OR B");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (A AND B AND C)", "A AND B");
        TestSimplifyExpressions.assertSimplifies("I = ((A OR B) AND (A OR B OR C))", "I = (A OR B)");
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Z)", "(X OR Y) AND (X OR Z)");
        TestSimplifyExpressions.assertSimplifies("(X AND Y AND V) OR (X AND Y AND Z)", "(X AND Y) AND (V OR Z)");
        TestSimplifyExpressions.assertSimplifies("((X OR Y OR V) AND (X OR Y OR Z)) = I", "((X OR Y) OR (V AND Z)) = I");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND V) OR ((X OR V) AND V)", "V");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND X) OR ((X OR V) AND V)", "X OR V");
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND Z) OR ((X OR V) AND V)", "(X OR V) AND (Z OR V)");
        TestSimplifyExpressions.assertSimplifies("X AND ((Y AND Z) OR (Y AND V) OR (Y AND X))", "X AND Y AND (Z OR V OR X)");
        TestSimplifyExpressions.assertSimplifies("(A AND B AND C AND D) OR (A AND B AND E) OR (A AND F)", "A AND ((B AND C AND D) OR (B AND E) OR F)");
        TestSimplifyExpressions.assertSimplifies("((A AND B) OR (A AND C)) AND D", "A AND (B OR C) AND D");
        TestSimplifyExpressions.assertSimplifies("((A OR B) AND (A OR C)) OR D", "(A OR B OR D) AND (A OR C OR D)");
        TestSimplifyExpressions.assertSimplifies("(((A AND B) OR (A AND C)) AND D) OR E", "(A OR E) AND (B OR C OR E) AND (D OR E)");
        TestSimplifyExpressions.assertSimplifies("(((A OR B) AND (A OR C)) OR D) AND E", "(A OR (B AND C) OR D) AND E");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D)", "(A OR C) AND (A OR D) AND (B OR C) AND (B OR D)");
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D) OR (E AND F)", "(A AND B) OR (C AND D) OR (E AND F)");
        TestSimplifyExpressions.assertSimplifies("(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)", "(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)");
    }

    private static void assertSimplifies(String expression, String expected) {
        ParsingOptions parsingOptions = new ParsingOptions();
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression, parsingOptions));
        Expression expectedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected, parsingOptions));
        Expression rewritten = SimplifyExpressions.rewrite((Expression)actualExpression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(TestSimplifyExpressions.booleanSymbolTypeMapFor(actualExpression)), (Metadata)METADATA, (LiteralEncoder)LITERAL_ENCODER, (TypeAnalyzer)new TypeAnalyzer(SQL_PARSER, METADATA));
        Assert.assertEquals((Object)TestSimplifyExpressions.normalize(rewritten), (Object)TestSimplifyExpressions.normalize(expectedExpression));
    }

    private static Map<Symbol, Type> booleanSymbolTypeMapFor(Expression expression) {
        return SymbolsExtractor.extractUnique((Expression)expression).stream().collect(Collectors.toMap(symbol -> symbol, symbol -> BooleanType.BOOLEAN));
    }

    @Test
    public void testPushesDownNegationsNumericTypes() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 = I2)", "I1 <> I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 > I2)", "I1 <= I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (I3 > I4))", "I1 <> I2 AND I3 <= I4");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (NOT NOT (I1 = I2) OR NOT(I3 > I4))", "I1 <> I2 AND I3 > I4");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (B1 AND B2) OR NOT (B3 OR B4))", "I1 <> I2 AND (NOT B1 OR NOT B2) AND (B3 OR B4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 IS DISTINCT FROM I2)", "NOT (I1 IS DISTINCT FROM I2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 = D2)", "D1 <> D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 <> D2)", "D1 = D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 = R2)", "R1 <> R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 <> R2)", "R1 = R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 IS DISTINCT FROM D2)", "NOT (D1 IS DISTINCT FROM D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 IS DISTINCT FROM R2)", "NOT (R1 IS DISTINCT FROM R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 > D2)", "NOT (D1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 >= D2)", "NOT (D1 >= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 < D2)", "NOT (D1 < D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 <= D2)", "NOT (D1 <= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 > R2)", "NOT (R1 > R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 >= R2)", "NOT (R1 >= R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 < R2)", "NOT (R1 < R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 <= R2)", "NOT (R1 <= R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (D1 <= D2)", "NOT (D1 <= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT NOT (D1 <= D2)", "D1 <= D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (R1 > R2)", "NOT (R1 > R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT NOT (R1 > R2)", "R1 > R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (D1 > D2))", "I1 <> I2 AND NOT (D1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (NOT NOT (R1 < R2) OR NOT(I1 > I2))", "NOT (R1 < R2) AND I1 > I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((D1 > D2) OR (B1 AND B2) OR NOT (B3 OR B4))", "NOT (D1 > D2) AND (NOT B1 OR NOT B2) AND (B3 OR B4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (((D1 > D2) AND (I1 < I2)) OR ((B1 AND B2) AND (R1 > R2)))", "(NOT (D1 > D2) OR I1 >= I2) AND ((NOT B1 OR NOT B2) OR NOT (R1 > R2))");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("IF (NOT (I1 < I2), D1, D2)", "IF (I1 >= I2, D1, D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 > 1)", "NOT (D1 > 1)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (1 > D2)", "NOT (1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 > 1)", "NOT (R1 > 1)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (1 > R2)", "NOT (1 > R2)");
    }

    private static void assertSimplifiesNumericTypes(String expression, String expected) {
        ParsingOptions parsingOptions = new ParsingOptions();
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression, parsingOptions));
        Expression expectedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected, parsingOptions));
        Expression rewritten = SimplifyExpressions.rewrite((Expression)actualExpression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(TestSimplifyExpressions.numericAndBooleanSymbolTypeMapFor(actualExpression)), (Metadata)METADATA, (LiteralEncoder)LITERAL_ENCODER, (TypeAnalyzer)new TypeAnalyzer(SQL_PARSER, METADATA));
        Assert.assertEquals((Object)TestSimplifyExpressions.normalize(rewritten), (Object)TestSimplifyExpressions.normalize(expectedExpression));
    }

    private static Map<Symbol, Type> numericAndBooleanSymbolTypeMapFor(Expression expression) {
        return SymbolsExtractor.extractUnique((Expression)expression).stream().collect(Collectors.toMap(symbol -> symbol, symbol -> {
            switch (symbol.getName().charAt(0)) {
                case 'I': {
                    return IntegerType.INTEGER;
                }
                case 'D': {
                    return DoubleType.DOUBLE;
                }
                case 'R': {
                    return RealType.REAL;
                }
                case 'B': {
                    return BooleanType.BOOLEAN;
                }
            }
            return BigintType.BIGINT;
        }));
    }

    private static Expression normalize(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new NormalizeExpressionRewriter(), (Expression)expression);
    }

    private static class NormalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private NormalizeExpressionRewriter() {
        }

        public Expression rewriteLogicalBinaryExpression(LogicalBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List predicates = ExpressionUtils.extractPredicates((LogicalBinaryExpression.Operator)node.getOperator(), (Expression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(Expression::toString)).collect(Collectors.toList());
            return ExpressionUtils.binaryExpression((LogicalBinaryExpression.Operator)node.getOperator(), predicates);
        }
    }
}

