/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSingleDistinctAggregationToGroupBy
extends BaseRuleTest {
    public TestSingleDistinctAggregationToGroupBy() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoDistinct() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input1"), p.symbol("input2"))))).doesNotFire();
    }

    @Test
    public void testMultipleDistincts() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("count(DISTINCT input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input1"), p.symbol("input2"))))).doesNotFire();
    }

    @Test
    public void testMixedDistinctAndNonDistinct() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("count(input2)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input1"), p.symbol("input2"))))).doesNotFire();
    }

    @Test
    public void testDistinctWithFilter() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output"), PlanBuilder.expression("count(DISTINCT input1) filter (where filter1)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().putIdentity(p.symbol("input1")).putIdentity(p.symbol("input2")).put(p.symbol("filter1"), PlanBuilder.expression("input2 > 0")).build(), (PlanNode)p.values(p.symbol("input1"), p.symbol("input2")))))).doesNotFire();
    }

    @Test
    public void testSingleAggregation() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output"), PlanBuilder.expression("count(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input"))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("output"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input"))), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("input"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("input"))));
    }

    @Test
    public void testMultipleAggregations() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("count(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("output2"), PlanBuilder.expression("sum(DISTINCT input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("input"))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.builder().put(Optional.of("output1"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"input"))).put(Optional.of("output2"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"input"))).build(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("input"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("input"))));
    }

    @Test
    public void testMultipleInputs() {
        this.tester().assertThat((Rule<?>)new SingleDistinctAggregationToGroupBy()).on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("output1"), PlanBuilder.expression("corr(DISTINCT x, y)"), (List<Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL)).addAggregation(p.symbol("output2"), PlanBuilder.expression("corr(DISTINCT y, x)"), (List<Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL)).source((PlanNode)p.values(p.symbol("x"), p.symbol("y"))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.builder().put(Optional.of("output1"), PlanMatchPattern.functionCall("corr", (List<String>)ImmutableList.of((Object)"x", (Object)"y"))).put(Optional.of("output2"), PlanMatchPattern.functionCall("corr", (List<String>)ImmutableList.of((Object)"y", (Object)"x"))).build(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("x", "y"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("x", "y"))));
    }
}

