/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.TransformCorrelatedJoinToJoin;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformCorrelatedJoinToJoin
extends BaseRuleTest {
    public TestTransformCorrelatedJoinToJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testRewriteInnerCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("b > a"), PlanMatchPattern.values("a"), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b"))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), CorrelatedJoinNode.Type.INNER, (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new LongLiteral("3")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("b > a AND b < 3"), PlanMatchPattern.values("a"), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b"))));
    }

    @Test
    public void testRewriteLeftCorrelatedJoin() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), CorrelatedJoinNode.Type.LEFT, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("b > a"), PlanMatchPattern.values("a"), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b"))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(a), CorrelatedJoinNode.Type.LEFT, (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)b.toSymbolReference(), (Expression)new LongLiteral("3")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b.toSymbolReference(), (Expression)a.toSymbolReference()), (PlanNode)p.values(b)));
        }).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("b > a AND b < 3"), PlanMatchPattern.values("a"), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("b"))));
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedJoinToJoin(this.tester().getMetadata())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }
}

