/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.WhenClause;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformCorrelatedScalarSubquery
extends BaseRuleTest {
    private static final ImmutableList<List<Expression>> ONE_ROW = ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")));
    private static final ImmutableList<List<Expression>> TWO_ROWS = ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new LongLiteral("2")));
    private Rule<?> rule = new TransformCorrelatedScalarSubquery((Metadata)MetadataManager.createTestMetadataManager());

    public TestTransformCorrelatedScalarSubquery() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutCorrelatedJoinlNode() {
        this.tester().assertThat(this.rule).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedNonScalar() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1"))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutProjection() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a")))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a2"), (Expression)PlanBuilder.expression("a * 2")), (PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS)))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression("a * 2")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a"))))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjectionOnTopEnforceSingleNode() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("a3"), (Expression)PlanBuilder.expression("a2 + 1")), (PlanNode)p.enforceSingleRow((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a2"), (Expression)PlanBuilder.expression("a * 2")), (PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)TWO_ROWS))))))).matches(PlanMatchPattern.project(PlanMatchPattern.filter(this.ensureScalarSubquery(), PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a3", (Object)PlanMatchPattern.expression("a2 + 1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression("a * 2")), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a")))))))));
    }

    @Test
    public void rewritesScalarSubquery() {
        this.tester().assertThat(this.rule).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.enforceSingleRow((PlanNode)p.filter(PlanBuilder.expression("1 = a"), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<List<Expression>>)ONE_ROW))))).matches(PlanMatchPattern.correlatedJoin((List<String>)ImmutableList.of((Object)"corr"), PlanMatchPattern.values("corr"), PlanMatchPattern.filter("1 = a", PlanMatchPattern.values("a"))));
    }

    private Expression ensureScalarSubquery() {
        return new SimpleCaseExpression((Expression)new SymbolReference("is_distinct"), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(new Cast((Expression)new FunctionCallBuilder(this.tester().getMetadata()).setName(QualifiedName.of((String)"fail")).addArgument((Type)IntegerType.INTEGER, (Expression)new LongLiteral(Long.toString(StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.ordinal()))).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral("Scalar sub-query has returned multiple rows")).build(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN))));
    }
}

