/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.TransformFilteringSemiJoinToInnerJoin;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformFilteringSemiJoinToInnerJoin
extends BaseRuleTest {
    public TestTransformFilteringSemiJoinToInnerJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testTransformSemiJoinToInnerJoin() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter(PlanBuilder.expression("a_in_b AND a > 5"), (PlanNode)p.semiJoin((PlanNode)p.values(a), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"a_in_b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a", "b")), Optional.of("a > 5"), PlanMatchPattern.values("a"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("b")))));
    }

    @Test
    public void testRemoveRedundantFilter() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter(PlanBuilder.expression("a_in_b"), (PlanNode)p.semiJoin((PlanNode)p.values(a), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"a_in_b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("a", "b")), Optional.empty(), PlanMatchPattern.values("a"), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("b")))));
    }

    @Test
    public void testFilterNotMatching() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter(PlanBuilder.expression("a > 5"), (PlanNode)p.semiJoin((PlanNode)p.values(a), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).doesNotFire();
    }

    @Test
    public void testDoNotRewriteInContextOfDelete() {
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter(PlanBuilder.expression("a_in_b"), (PlanNode)p.semiJoin((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)a), true), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new TransformFilteringSemiJoinToInnerJoin()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol aInB = p.symbol("a_in_b");
            return p.filter(PlanBuilder.expression("a_in_b"), (PlanNode)p.semiJoin((PlanNode)p.project(Assignments.of((Symbol)a, (Expression)PlanBuilder.expression("c")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)c), true)), (PlanNode)p.values(b), a, b, aInB, Optional.empty(), Optional.empty(), Optional.empty()));
        }).doesNotFire();
    }
}

