/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.iterative.rule.test.RuleTester;
import io.prestosql.testing.LocalQueryRunner;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class BaseRuleTest {
    private RuleTester tester;
    private List<Plugin> plugins;

    public BaseRuleTest(Plugin ... plugins) {
        this.plugins = ImmutableList.copyOf((Object[])plugins);
    }

    @BeforeClass
    public final void setUp() {
        Optional<LocalQueryRunner> localQueryRunner = this.createLocalQueryRunner();
        if (localQueryRunner.isPresent()) {
            this.plugins.forEach(plugin -> ((LocalQueryRunner)localQueryRunner.get()).installPlugin(plugin));
            this.tester = new RuleTester(localQueryRunner.get());
        } else {
            this.tester = RuleTester.defaultRuleTester(this.plugins, (Map<String, String>)ImmutableMap.of(), Optional.empty());
        }
    }

    protected Optional<LocalQueryRunner> createLocalQueryRunner() {
        return Optional.empty();
    }

    @AfterClass(alwaysRun=true)
    public final void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    protected RuleTester tester() {
        return this.tester;
    }
}

