/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.ExpressionTestUtils;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.ExpressionEquivalence;
import io.prestosql.sql.tree.Expression;
import io.prestosql.transaction.TestingTransactionManager;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionEquivalence {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final ExpressionEquivalence EQUIVALENCE = new ExpressionEquivalence(METADATA, new TypeAnalyzer(SQL_PARSER, METADATA));
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("a_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("b_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("c_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("d_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("e_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("f_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("g_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("h_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("a_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("b_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("c_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("d_bigint"), (Object)BigintType.BIGINT).put((Object)new Symbol("b_double"), (Object)DoubleType.DOUBLE).build());

    @Test
    public void testEquivalent() {
        TestExpressionEquivalence.assertEquivalent("CAST(null AS BIGINT)", "CAST(null as BIGINT)");
        TestExpressionEquivalence.assertEquivalent("a_bigint < b_double", "b_double > a_bigint");
        TestExpressionEquivalence.assertEquivalent("true", "true");
        TestExpressionEquivalence.assertEquivalent("4", "4");
        TestExpressionEquivalence.assertEquivalent("4.4", "4.4");
        TestExpressionEquivalence.assertEquivalent("'foo'", "'foo'");
        TestExpressionEquivalence.assertEquivalent("4 = 5", "5 = 4");
        TestExpressionEquivalence.assertEquivalent("4.4 = 5.5", "5.5 = 4.4");
        TestExpressionEquivalence.assertEquivalent("'foo' = 'bar'", "'bar' = 'foo'");
        TestExpressionEquivalence.assertEquivalent("4 <> 5", "5 <> 4");
        TestExpressionEquivalence.assertEquivalent("4 is distinct from 5", "5 is distinct from 4");
        TestExpressionEquivalence.assertEquivalent("4 < 5", "5 > 4");
        TestExpressionEquivalence.assertEquivalent("4 <= 5", "5 >= 4");
        TestExpressionEquivalence.assertEquivalent("TIMESTAMP '2020-05-10 12:34:56.123456789' = TIMESTAMP '2021-05-10 12:34:56.123456789'", "TIMESTAMP '2021-05-10 12:34:56.123456789' = TIMESTAMP '2020-05-10 12:34:56.123456789'");
        TestExpressionEquivalence.assertEquivalent("TIMESTAMP '2020-05-10 12:34:56.123456789 +8' = TIMESTAMP '2021-05-10 12:34:56.123456789 +8'", "TIMESTAMP '2021-05-10 12:34:56.123456789 +8' = TIMESTAMP '2020-05-10 12:34:56.123456789 +8'");
        TestExpressionEquivalence.assertEquivalent("mod(4, 5)", "mod(4, 5)");
        TestExpressionEquivalence.assertEquivalent("a_bigint", "a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint = b_bigint", "b_bigint = a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint < b_bigint", "b_bigint > a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint < b_double", "b_double > a_bigint");
        TestExpressionEquivalence.assertEquivalent("true and false", "false and true");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 and 6 < 7", "7 > 6 and 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 or 6 < 7", "7 > 6 or 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("a_bigint <= b_bigint and c_bigint < d_bigint", "d_bigint > c_bigint and b_bigint >= a_bigint");
        TestExpressionEquivalence.assertEquivalent("a_bigint <= b_bigint or c_bigint < d_bigint", "d_bigint > c_bigint or b_bigint >= a_bigint");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 and 4 <= 5", "4 <= 5");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 and 6 < 7", "7 > 6 and 5 >= 4 and 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("2 <= 3 and 4 <= 5 and 6 < 7", "7 > 6 and 5 >= 4 and 3 >= 2");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 or 4 <= 5", "4 <= 5");
        TestExpressionEquivalence.assertEquivalent("4 <= 5 or 6 < 7", "7 > 6 or 5 >= 4 or 5 >= 4");
        TestExpressionEquivalence.assertEquivalent("2 <= 3 or 4 <= 5 or 6 < 7", "7 > 6 or 5 >= 4 or 3 >= 2");
        TestExpressionEquivalence.assertEquivalent("a_boolean and b_boolean and c_boolean", "c_boolean and b_boolean and a_boolean");
        TestExpressionEquivalence.assertEquivalent("(a_boolean and b_boolean) and c_boolean", "(c_boolean and b_boolean) and a_boolean");
        TestExpressionEquivalence.assertEquivalent("a_boolean and (b_boolean or c_boolean)", "a_boolean and (c_boolean or b_boolean) and a_boolean");
        TestExpressionEquivalence.assertEquivalent("(a_boolean or b_boolean or c_boolean) and (d_boolean or e_boolean) and (f_boolean or g_boolean or h_boolean)", "(h_boolean or g_boolean or f_boolean) and (b_boolean or a_boolean or c_boolean) and (e_boolean or d_boolean)");
        TestExpressionEquivalence.assertEquivalent("(a_boolean and b_boolean and c_boolean) or (d_boolean and e_boolean) or (f_boolean and g_boolean and h_boolean)", "(h_boolean and g_boolean and f_boolean) or (b_boolean and a_boolean and c_boolean) or (e_boolean and d_boolean)");
        TestExpressionEquivalence.assertEquivalent("reduce(ARRAY [b_boolean], false, (s, x) -> s AND x, s -> s)", "reduce(ARRAY [b_boolean], false, (s, x) -> x AND s, s -> s)");
    }

    private static void assertEquivalent(@Language(value="SQL") String left, @Language(value="SQL") String right) {
        ParsingOptions parsingOptions = new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE);
        Expression leftExpression = ExpressionTestUtils.planExpression(METADATA, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(left, parsingOptions));
        Expression rightExpression = ExpressionTestUtils.planExpression(METADATA, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(right, parsingOptions));
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        TypeProvider types = TypeProvider.copyOf(symbols.stream().collect(Collectors.toMap(Function.identity(), TestExpressionEquivalence::generateType)));
        Assert.assertTrue((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, types), (String)String.format("Expected (%s) and (%s) to be equivalent", left, right));
        Assert.assertTrue((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, types), (String)String.format("Expected (%s) and (%s) to be equivalent", right, left));
    }

    @Test
    public void testNotEquivalent() {
        TestExpressionEquivalence.assertNotEquivalent("CAST(null AS BOOLEAN)", "false");
        TestExpressionEquivalence.assertNotEquivalent("false", "CAST(null AS BOOLEAN)");
        TestExpressionEquivalence.assertNotEquivalent("true", "false");
        TestExpressionEquivalence.assertNotEquivalent("4", "5");
        TestExpressionEquivalence.assertNotEquivalent("4.4", "5.5");
        TestExpressionEquivalence.assertNotEquivalent("'foo'", "'bar'");
        TestExpressionEquivalence.assertNotEquivalent("4 = 5", "5 = 6");
        TestExpressionEquivalence.assertNotEquivalent("4 <> 5", "5 <> 6");
        TestExpressionEquivalence.assertNotEquivalent("4 is distinct from 5", "5 is distinct from 6");
        TestExpressionEquivalence.assertNotEquivalent("4 < 5", "5 > 6");
        TestExpressionEquivalence.assertNotEquivalent("4 <= 5", "5 >= 6");
        TestExpressionEquivalence.assertNotEquivalent("mod(4, 5)", "mod(5, 4)");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint", "b_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint = b_bigint", "b_bigint = c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint < b_bigint", "b_bigint > c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint < b_double", "b_double > c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("4 <= 5 and 6 < 7", "7 > 6 and 5 >= 6");
        TestExpressionEquivalence.assertNotEquivalent("4 <= 5 or 6 < 7", "7 > 6 or 5 >= 6");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint <= b_bigint and c_bigint < d_bigint", "d_bigint > c_bigint and b_bigint >= c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("a_bigint <= b_bigint or c_bigint < d_bigint", "d_bigint > c_bigint or b_bigint >= c_bigint");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123 +00:00' AS varchar)", "CAST(TIME '14:34:56.123 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123456 +00:00' AS varchar)", "CAST(TIME '14:34:56.123456 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123456789 +00:00' AS varchar)", "CAST(TIME '14:34:56.123456789 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIME '12:34:56.123456789012 +00:00' AS varchar)", "CAST(TIME '14:34:56.123456789012 +02:00' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123 Europe/Paris' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123456 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123456 Europe/Paris' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123456789 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123456789 Europe/Paris' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("CAST(TIMESTAMP '2020-05-10 12:34:56.123456789012 Europe/Warsaw' AS varchar)", "CAST(TIMESTAMP '2020-05-10 12:34:56.123456789012 Europe/Paris' AS varchar)");
        TestExpressionEquivalence.assertNotEquivalent("reduce(ARRAY [b_boolean], false, (s, x) -> s AND x, s -> s)", "reduce(ARRAY [b_boolean], false, (s, x) -> s OR x, s -> s)");
    }

    private static void assertNotEquivalent(@Language(value="SQL") String left, @Language(value="SQL") String right) {
        ParsingOptions parsingOptions = new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE);
        Expression leftExpression = ExpressionTestUtils.planExpression(METADATA, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(left, parsingOptions));
        Expression rightExpression = ExpressionTestUtils.planExpression(METADATA, SessionTestUtils.TEST_SESSION, TYPE_PROVIDER, SQL_PARSER.createExpression(right, parsingOptions));
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        TypeProvider types = TypeProvider.copyOf(symbols.stream().collect(Collectors.toMap(Function.identity(), TestExpressionEquivalence::generateType)));
        Assert.assertFalse((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, types), (String)String.format("Expected (%s) and (%s) to not be equivalent", left, right));
        Assert.assertFalse((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, types), (String)String.format("Expected (%s) and (%s) to not be equivalent", right, left));
    }

    private static boolean areExpressionEquivalent(Expression leftExpression, Expression rightExpression, TypeProvider types) {
        return (Boolean)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, transactionSession -> EQUIVALENCE.areExpressionsEquivalent(transactionSession, leftExpression, rightExpression, types));
    }

    private static Type generateType(Symbol symbol) {
        String typeName = (String)Splitter.on((char)'_').limit(2).splitToList((CharSequence)symbol.getName()).get(1);
        return METADATA.getType(new TypeSignature(typeName, (List)ImmutableList.of()));
    }
}

