/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestFullOuterJoinWithCoalesce
extends BasePlanTest {
    @Test(enabled=false)
    public void testFullOuterJoinWithCoalesce() {
        this.assertDistributedPlan("SELECT coalesce(ts.a, r.a) FROM (   SELECT coalesce(t.a, s.a) AS a    FROM (VALUES 1, 2, 3) t(a)    FULL OUTER JOIN (VALUES 1, 4) s(a)   ON t.a = s.a) ts FULL OUTER JOIN (VALUES 2, 5) r(a) on ts.a = r.a", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(ts, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ts", "r")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ts", (Object)PlanMatchPattern.expression("coalesce(t, s)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t", "s")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"s"))))))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))));
    }

    @Test(enabled=false)
    public void testArgumentsInDifferentOrder() {
        this.assertDistributedPlan("SELECT coalesce(l.a, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(l, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l", "r")), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l"))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
        this.assertDistributedPlan("SELECT coalesce(r.a, l.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(r, l)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l", "r")), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l"))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
    }

    @Test
    public void testCoalesceWithManyArguments() {
        this.assertDistributedPlan("SELECT coalesce(l.a, m.a, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) m(a) ON l.a = m.a FULL OUTER JOIN (VALUES 2, 5) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(l, m, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l", "r")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l", "m")), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l"))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"m"))))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
    }

    @Test
    public void testComplexArgumentToCoalesce() {
        this.assertDistributedPlan("SELECT coalesce(l.a, m.a + 1, r.a) FROM (VALUES 1, 2, 3) l(a) FULL OUTER JOIN (VALUES 1, 4) m(a) ON l.a = m.a FULL OUTER JOIN (VALUES 2, 5) r(a) ON l.a = r.a GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("coalesce(l, m + 1, r)")), PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l", "r")), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("l", "m")), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"l"))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"m"))))), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"))))))))));
    }
}

