/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.rule.MergeExcept;
import io.prestosql.sql.planner.iterative.rule.MergeIntersect;
import io.prestosql.sql.planner.iterative.rule.MergeUnion;
import io.prestosql.sql.planner.iterative.rule.PruneDistinctAggregation;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.optimizations.PruneUnreferencedOutputs;
import io.prestosql.sql.planner.optimizations.UnaliasSymbolReferences;
import java.util.List;
import java.util.Set;
import org.testng.annotations.Test;

public class TestSetFlattening
extends BasePlanTest {
    @Test
    public void testFlattensUnion() {
        this.assertPlan("(SELECT * FROM nation UNION SELECT * FROM nation)UNION (SELECT * FROM nation UNION SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensUnionAll() {
        this.assertPlan("(SELECT * FROM nation UNION ALL SELECT * FROM nation)UNION ALL (SELECT * FROM nation UNION ALL SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensUnionAndUnionAllWhenAllowed() {
        this.assertPlan("SELECT * FROM nation UNION ALL (SELECT * FROM nation UNION (SELECT * FROM nation UNION ALL select * FROM nation))", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))))));
    }

    @Test
    public void testFlattensIntersect() {
        this.assertPlan("(SELECT * FROM nation INTERSECT SELECT * FROM nation)INTERSECT (SELECT * FROM nation INTERSECT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.intersect(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensOnlyFirstInputOfExcept() {
        this.assertPlan("(SELECT * FROM nation EXCEPT SELECT * FROM nation)EXCEPT (SELECT * FROM nation EXCEPT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")))));
    }

    @Test
    public void testDoesNotFlattenDifferentSetOperations() {
        this.assertPlan("(SELECT * FROM nation EXCEPT SELECT * FROM nation)UNION (SELECT * FROM nation INTERSECT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")), PlanMatchPattern.intersect(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")))));
    }

    @Override
    protected void assertPlan(String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.getQueryRunner().getMetadata()), (Object)new PruneUnreferencedOutputs(this.getQueryRunner().getMetadata()), (Object)new IterativeOptimizer(new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new MergeUnion(), (Object)new MergeIntersect(), (Object)new MergeExcept(), (Object)new PruneDistinctAggregation())));
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

