/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.airlift.json.JsonCodec;
import io.prestosql.spi.statistics.ColumnStatisticMetadata;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.statistics.TableStatisticType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.plan.StatisticAggregationsDescriptor;
import io.prestosql.testing.assertions.Assert;
import org.testng.annotations.Test;

public class TestStatisticAggregationsDescriptor {
    private static final ImmutableList<String> COLUMNS = ImmutableList.of((Object)"", (Object)"col1", (Object)"$:###:;", (Object)"abc+dddd___");

    @Test
    public void testColumnStatisticMetadataKeySerializationRoundTrip() {
        for (String column : COLUMNS) {
            for (ColumnStatisticType type : ColumnStatisticType.values()) {
                ColumnStatisticMetadata expected = new ColumnStatisticMetadata(column, type);
                Assert.assertEquals((Object)StatisticAggregationsDescriptor.ColumnStatisticMetadataKeyDeserializer.deserialize((String)StatisticAggregationsDescriptor.ColumnStatisticMetadataKeySerializer.serialize((ColumnStatisticMetadata)expected)), (Object)expected);
            }
        }
    }

    @Test
    public void testSerializationRoundTrip() {
        JsonCodec codec = JsonCodec.jsonCodec((TypeToken)new TypeToken<StatisticAggregationsDescriptor<Symbol>>(){});
        TestStatisticAggregationsDescriptor.assertSerializationRoundTrip((JsonCodec<StatisticAggregationsDescriptor<Symbol>>)codec, (StatisticAggregationsDescriptor<Symbol>)StatisticAggregationsDescriptor.builder().build());
        TestStatisticAggregationsDescriptor.assertSerializationRoundTrip((JsonCodec<StatisticAggregationsDescriptor<Symbol>>)codec, TestStatisticAggregationsDescriptor.createTestDescriptor());
    }

    private static void assertSerializationRoundTrip(JsonCodec<StatisticAggregationsDescriptor<Symbol>> codec, StatisticAggregationsDescriptor<Symbol> descriptor) {
        Assert.assertEquals((Object)codec.fromJson(codec.toJson(descriptor)), descriptor);
    }

    private static StatisticAggregationsDescriptor<Symbol> createTestDescriptor() {
        StatisticAggregationsDescriptor.Builder builder = StatisticAggregationsDescriptor.builder();
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        for (String column : COLUMNS) {
            for (ColumnStatisticType type : ColumnStatisticType.values()) {
                builder.addColumnStatistic(new ColumnStatisticMetadata(column, type), (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
            }
            builder.addGrouping(column, (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
        }
        builder.addTableStatistic(TableStatisticType.ROW_COUNT, (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
        return builder.build();
    }

    private static Symbol testSymbol(SymbolAllocator allocator) {
        return allocator.newSymbol("test_symbol", (Type)BigintType.BIGINT);
    }
}

