/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.sanity.DynamicFiltersChecker;
import io.prestosql.sql.tree.Expression;
import io.prestosql.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDynamicFiltersChecker
extends BasePlanTest {
    private Metadata metadata;
    private TypeOperators typeOperators = new TypeOperators();
    private PlanBuilder builder;
    private Symbol lineitemOrderKeySymbol;
    private TableScanNode lineitemTableScanNode;
    private Symbol ordersOrderKeySymbol;
    private TableScanNode ordersTableScanNode;

    @BeforeClass
    public void setup() {
        this.metadata = this.getQueryRunner().getMetadata();
        this.builder = new PlanBuilder(new PlanNodeIdAllocator(), this.metadata);
        CatalogName catalogName = this.getCurrentConnectorId();
        TableHandle lineitemTableHandle = new TableHandle(catalogName, (ConnectorTableHandle)new TpchTableHandle("lineitem", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.lineitemOrderKeySymbol = this.builder.symbol("LINEITEM_OK", (Type)BigintType.BIGINT);
        this.lineitemTableScanNode = this.builder.tableScan(lineitemTableHandle, (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.lineitemOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
        TableHandle ordersTableHandle = new TableHandle(catalogName, (ConnectorTableHandle)new TpchTableHandle("orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
        this.ordersOrderKeySymbol = this.builder.symbol("ORDERS_OK", (Type)BigintType.BIGINT);
        this.ordersTableScanNode = this.builder.tableScan(ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.ordersOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="Dynamic filters \\[DF\\] present in join were not fully consumed by it's probe side.")
    public void testUnconsumedDynamicFilterInJoin() {
        JoinNode root = this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(PlanBuilder.expression("ORDERS_OK > 0"), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="Dynamic filters \\[DF\\] present in join were consumed by it's build side.")
    public void testDynamicFilterConsumedOnBuildSide() {
        JoinNode root = this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference()), (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference()), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="All consumed dynamic filters could not be matched with a join/semi-join.")
    public void testUnmatchedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="Dynamic filters \\[Descriptor\\{id=DF, input=\"ORDERS_OK\", operator=EQUAL, nullAllowed=false\\}\\] present in filter predicate whose source is not a table scan.")
    public void testDynamicFilterNotAboveTableScan() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.lineitemOrderKeySymbol)), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="All consumed dynamic filters could not be matched with a join/semi-join.")
    public void testUnmatchedNestedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{ExpressionUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK IS NULL"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), ExpressionUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK IS NOT NULL"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())})}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="Dynamic filter expression \\(\"LINEITEM_OK\" \\+ BIGINT '1'\\) must be a SymbolReference or a CAST of SymbolReference.")
    public void testUnsupportedDynamicFilterExpression() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)PlanBuilder.expression("LINEITEM_OK + BIGINT'1'")), (PlanNode)this.lineitemTableScanNode), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="The expression CAST\\(\"LINEITEM_OK\" AS INT\\) within in a CAST in dynamic filter must be a SymbolReference.")
    public void testUnsupportedCastExpression() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)PlanBuilder.expression("CAST(CAST(LINEITEM_OK AS INT) AS BIGINT)")), (PlanNode)this.lineitemTableScanNode), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="The dynamic filter DF present in semi-join was not consumed by it's source side.")
    public void testUnconsumedDynamicFilterInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(PlanBuilder.expression("ORDERS_OK > 0"), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="The dynamic filter DF present in semi-join was consumed by it's filtering source side.")
    public void testDynamicFilterConsumedOnFilteringSourceSideInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("ORDERS_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("LINEITEM_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="All consumed dynamic filters could not be matched with a join/semi-join.")
    public void testUnmatchedDynamicFilterInSemiJoin() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.semiJoin((PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("ORDERS_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        this.validatePlan((PlanNode)root);
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="Dynamic filters \\[Descriptor\\{id=DF, input=\"ORDERS_OK\", operator=EQUAL, nullAllowed=false\\}\\] present in filter predicate whose source is not a table scan.")
    public void testDynamicFilterNotAboveTableScanWithSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(ExpressionUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{PlanBuilder.expression("ORDERS_OK > 0"), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.ordersOrderKeySymbol)), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        this.validatePlan((PlanNode)root);
    }

    private void validatePlan(PlanNode root) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new DynamicFiltersChecker().validate(root, session, this.metadata, this.typeOperators, new TypeAnalyzer(new SqlParser(), this.metadata), TypeProvider.empty(), WarningCollector.NOOP);
            return null;
        });
    }
}

