/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestAggregation {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testQuantifiedComparison() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT v > ALL (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k")).hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT v > ANY (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k")).hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT v > SOME (VALUES 1) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k")).hasMessageContaining("must be an aggregate expression or appear in GROUP BY clause");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count_if(v > ALL (VALUES 0, 1)) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k")))).matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count_if(v > ANY (VALUES 0, 1)) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k")))).matches("VALUES BIGINT '2'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT 1 > ALL (VALUES k) FROM (VALUES (1, 1), (1, 2)) t(k, v) GROUP BY k")).hasMessageContaining("line 1:17: Given correlated subquery is not supported");
    }
}

