/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestColumnMask {
    private static final String CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String USER = "user";
    private static final String VIEW_OWNER = "view-owner";
    private static final String RUN_AS_USER = "run-as-user";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(Identity.forUser((String)"user").build()).build();
    private QueryAssertions assertions;
    private TestingAccessControlManager accessControl;

    @BeforeClass
    public void init() {
        LocalQueryRunner runner = LocalQueryRunner.builder((Session)SESSION).build();
        runner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        ConnectorViewDefinition view = new ConnectorViewDefinition("SELECT nationkey, name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("nationkey", BigintType.BIGINT.getTypeId()), (Object)new ConnectorViewDefinition.ViewColumn("name", VarcharType.createVarcharType((int)25).getTypeId())), Optional.empty(), Optional.of(VIEW_OWNER), false);
        MockConnectorFactory mock = MockConnectorFactory.builder().withGetViews((s, prefix) -> ImmutableMap.builder().put((Object)new SchemaTableName("default", "nation_view"), (Object)view).build()).build();
        runner.createCatalog(MOCK_CATALOG, (ConnectorFactory)mock, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSimpleMask() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-custkey"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '-370'");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "NULL"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey FROM orders WHERE orderkey = 1")))).matches("VALUES CAST(NULL AS BIGINT)");
    }

    @Test
    public void testMultipleMasksOnSameColumn() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-custkey"));
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "custkey * 2"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '-740'");
    }

    @Test
    public void testMultipleMasksOnDifferentColumns() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-custkey"));
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderstatus", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "'X'"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey, orderstatus FROM orders WHERE orderkey = 1")))).matches("VALUES (BIGINT '-370', 'X')");
    }

    @Test
    public void testReferenceInUsingClause() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "IF(orderkey = 1, -orderkey)"));
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "lineitem"), "orderkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "IF(orderkey = 1, -orderkey)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders JOIN lineitem USING (orderkey)")))).matches("VALUES BIGINT '6'");
    }

    @Test
    public void testCoercibleType() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "CAST(clerk AS VARCHAR(5))"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT clerk FROM orders WHERE orderkey = 1")))).matches("VALUES CAST('Clerk' AS VARCHAR(15))");
    }

    @Test
    public void testSubquery() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT cast(max(name) AS VARCHAR(15)) FROM nation)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT clerk FROM orders WHERE orderkey = 1")))).matches("VALUES CAST('VIETNAM' AS VARCHAR(15))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT cast(max(name) AS VARCHAR(15)) FROM nation WHERE nationkey = orderkey)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT clerk FROM orders WHERE orderkey = 1")))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(15))");
    }

    @Test
    public void testView() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", VIEW_OWNER, new ViewExpression(VIEW_OWNER, Optional.empty(), Optional.empty(), "reverse(name)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build(), "SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", VIEW_OWNER, new ViewExpression(VIEW_OWNER, Optional.of(CATALOG), Optional.of("tiny"), "reverse(name)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)VIEW_OWNER).build()).build(), "SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "reverse(name)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build(), "SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_view"), "name", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "reverse(name)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
    }

    @Test
    public void testTableReferenceInWithClause() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "custkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-custkey"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t AS (SELECT custkey FROM orders WHERE orderkey = 1) SELECT * FROM t")))).matches("VALUES BIGINT '-370'");
    }

    @Test
    public void testOtherSchema() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("sf1"), "(SELECT count(*) FROM customer)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT max(orderkey) FROM orders")))).matches("VALUES BIGINT '150000'");
    }

    @Test
    public void testDifferentIdentity() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "100"));
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT sum(orderkey) FROM orders)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT max(orderkey) FROM orders")))).matches("VALUES BIGINT '1500000'");
    }

    @Test
    public void testRecursion() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM orders)"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching(".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM local.tiny.orders)"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching(".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", RUN_AS_USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM orders)"));
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT orderkey FROM orders)"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching(".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
    }

    @Test
    public void testLimitedScope() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "customer"), "custkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT min(custkey) FROM customer WHERE customer.custkey = orders.custkey) FROM orders")).hasMessageMatching("\\Qline 1:34: Invalid column mask for 'local.tiny.customer.custkey': Column 'orderkey' cannot be resolved\\E");
    }

    @Test
    public void testSqlInjection() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "nation"), "name", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "(SELECT name FROM region WHERE regionkey = 0)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH region(regionkey, name) AS (VALUES (0, 'ASIA'))SELECT name FROM nation ORDER BY name LIMIT 1")))).matches("VALUES CAST('AFRICA' AS VARCHAR(25))");
    }

    @Test
    public void testInvalidMasks() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "$$$"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching("\\Qline 1:22: Invalid column mask for 'local.tiny.orders.orderkey': mismatched input '$'. Expecting: <expression>\\E");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "unknown_column"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching("\\Qline 1:22: Invalid column mask for 'local.tiny.orders.orderkey': Column 'unknown_column' cannot be resolved\\E");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "'foo'"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching("\\Qline 1:22: Expected column mask for 'local.tiny.orders.orderkey' to be of type bigint, but was varchar(3)\\E");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "count(*) > 0"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching("\\Qline 1:10: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [count(*)]\\E");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(RUN_AS_USER, Optional.of(CATALOG), Optional.of("tiny"), "row_number() OVER () > 0"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching("\\Qline 1:22: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [row_number() OVER ()]\\E");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "grouping(orderkey) = 0"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching("\\Qline 1:20: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [GROUPING (orderkey)]\\E");
    }

    @Test
    public void testShowStats() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "7"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT * FROM orders)")))).containsAll("VALUES (CAST('orderkey' AS varchar), CAST(NULL AS double), 1e0, 0e1, NULL, '7', '7'),(CAST('clerk' AS varchar), 15e3, 1e3, 0e1, NULL, CAST(NULL AS varchar), CAST(NULL AS varchar)),(NULL, NULL, NULL, NULL, 15e3, NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT orderkey FROM orders)")))).matches("VALUES (CAST('orderkey' AS varchar), CAST(NULL AS double), 1e0, 0e1, NULL, CAST('7' AS varchar), CAST('7' AS varchar)),(NULL, NULL, NULL, NULL, 15e3, NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT clerk FROM orders)")))).matches("VALUES (CAST('clerk' AS varchar), 15e3, 1e3, 0e1, NULL, CAST(NULL AS varchar), CAST(NULL AS varchar)),(NULL, NULL, NULL, NULL, 15e3, NULL, NULL)");
    }

    @Test
    public void testJoin() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.of(CATALOG), Optional.of("tiny"), "orderkey + 1"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders JOIN orders USING (orderkey)")))).matches("VALUES BIGINT '15000'");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "-orderkey"));
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "orderkey * 2"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders JOIN orders USING (orderkey)")))).matches("VALUES BIGINT '15000'");
    }

    @Test
    public void testColumnMaskingUsingRestrictedColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.custkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "orderkey", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "custkey"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching("\\QAccess Denied: Cannot select from columns [orderkey, custkey] in table or view local.tiny.orders");
    }

    @Test
    public void testInsertWithColumnMasking() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "clerk"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO orders SELECT * FROM orders")).hasMessageMatching("\\QInsert into table with column masks");
    }

    @Test
    public void testDeleteWithColumnMasking() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "clerk"));
        Assertions.assertThatThrownBy(() -> this.assertions.query("DELETE FROM orders")).hasMessageMatching("\\Qline 1:1: Delete from table with column mask");
    }

    @Test
    public void testNotReferencedAndDeniedColumnMasking() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.clerk", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "clerk"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT orderkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '1'");
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.totalprice", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "totalprice", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "totalprice"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT orderkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '1'");
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.clerk", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.orderstatus", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(CATALOG, "tiny", "orders"), "clerk", USER, new ViewExpression(USER, Optional.empty(), Optional.empty(), "(SELECT orderstatus FROM local.tiny.orders)"));
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT orderkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '1'");
    }
}

