/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestExpressions {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBooleanExpressionInCase() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IS NULL WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IS NOT NULL WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 BETWEEN 0 AND 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 NOT BETWEEN 0 AND 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 IN (1, 2) WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 NOT IN (1, 2) WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 = 1 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 = 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 < 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 10");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CASE 1 > 2 WHEN true THEN 10 ELSE 20 END")))).matches("VALUES 20");
    }

    @Test
    public void testInlineNullBind() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT try(k) FROM (SELECT null) t(k)")))).matches("VALUES null");
    }
}

