/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestGrouping {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testImplicitCoercions() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT GROUPING(k), SUM(v) + 1e0 FROM (VALUES (1, 1)) AS t(k,v) GROUP BY k")))).matches("VALUES (0, 2e0)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT\n    1e0 * count(*),     grouping(x) FROM (VALUES 1) t(x) GROUP BY GROUPING SETS ((x), ()) ")))).matches("VALUES (1e0, 1), (1e0, 0)");
    }

    @Test
    public void testFilter() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a, b, grouping(a, b) FROM (VALUES ('x0', 'y0'), ('x1', 'y1') ) AS t (a, b) GROUP BY CUBE (a, b)HAVING grouping(a, b) = 0")))).matches("VALUES ('x0', 'y0', 0), ('x1', 'y1', 0)");
    }
}

