/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoin {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testCrossJoinEliminationWithOuterJoin() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH   a AS (SELECT id FROM (VALUES (1)) AS t(id)),  b AS (SELECT id FROM (VALUES (1)) AS t(id)),  c AS (SELECT id FROM (VALUES ('1')) AS t(id)),  d as (SELECT id FROM (VALUES (1)) AS t(id))SELECT a.id FROM a LEFT JOIN b ON a.id = b.id JOIN c ON a.id = CAST(c.id AS bigint) JOIN d ON d.id = a.id")))).matches("VALUES 1");
    }

    @Test
    public void testJoinOnNan() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(x) AS (VALUES if(rand() > 0, nan())) SELECT * FROM t t1 JOIN t t2 ON NOT t1.x < t2.x")))).matches("VALUES (nan(), nan())");
    }

    @Test
    public void testInPredicateInJoinCriteria() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH     t(x, y) AS (VALUES (1, 10), (2, 20)),     u(x) AS (VALUES 1, 2),     w(z) AS (VALUES 10, 20) SELECT *\nFROM t LEFT JOIN u ON t.x = u.x AND t.y IN (SELECT z FROM w)")))).matches("VALUES (2, 20, 2), (1, 10, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL), (2, NULL), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL), (2, NULL), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1), (NULL, 3), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1), (NULL, 3), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (SELECT v.x FROM (VALUES 1, 2) v(x) WHERE u.x = v.x)")))).matches("VALUES (1,1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (SELECT v.x FROM (VALUES 1, 2) v(x) WHERE t.x = v.x)")))).matches("VALUES (1,1)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES t.x)")).hasMessage("line 1:94: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES u.x)")).hasMessage("line 1:94: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES t.x)")).hasMessage("line 1:94: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES u.x)")).hasMessage("line 1:94: Reference to column 'u.x' from outer scope not allowed in this context");
    }

    @Test
    public void testQuantifiedComparisonInJoinCriteria() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x > ALL (VALUES 1)")))).matches("VALUES (1, 3), (2, 3), (NULL, 3), (NULL, 1), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON t.x + u.x > ALL (VALUES 2)")))).matches("VALUES (1, 3), (2, 1), (2, 3)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x + u.x > ALL (VALUES 1)"));
    }
}

