/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLateral {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testUncorrelatedLateral() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1, 2, 3)")))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1), (VALUES 'a')")))).matches("VALUES (1, 'a')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1) CROSS JOIN (VALUES 'a')")))).matches("VALUES (1, 'a')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM LATERAL (VALUES 1) t(a)")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1) t(a), LATERAL (SELECT * FROM LATERAL (SELECT a))")))).matches("VALUES (1, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM LATERAL (SELECT a)) FROM (VALUES 1) t(a)")))).matches("VALUES 1");
    }

    @Test
    public void testNotInScope() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1) t(a), (SELECT * FROM LATERAL (SELECT a))")).hasMessage("line 1:63: Column 'a' cannot be resolved");
    }
}

