/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestNumericalStability {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testVariance() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(VAR_SAMP(x + exp(30))/VAR_SAMP(x) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)")))).matches("VALUES 1.00");
    }

    @Test
    public void testCovariance() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(COVAR_SAMP(x + exp(30), x + exp(30))/VAR_SAMP(x) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)")))).matches("VALUES 1.00");
    }

    @Test
    public void testCorrelation() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(CORR(x + exp(30), x + exp(30)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)")))).matches("VALUES 1.00");
    }

    @Test
    public void testRegressionSlope() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(REGR_SLOPE((x + exp(30)) * 5 + 8, x + exp(30)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)")))).matches("VALUES 5.00");
    }

    @Test
    public void testRegressionIntercept() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT CAST(REGR_INTERCEPT((x + exp(20)) * 5 + 8, x + exp(20)) AS DECIMAL(3,2)) FROM (VALUES 1.0, 2.0, 3.0, 4.0, 5.0) AS X(x)")))).matches("VALUES 8.00");
    }
}

