/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestShowQueries {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog("local").setSchema("default").build());
        queryRunner.createCatalog("mock", (ConnectorFactory)MockConnectorFactory.builder().withGetColumns(schemaTableName -> ImmutableList.of((Object)ColumnMetadata.builder().setName("colaa").setType((Type)BigintType.BIGINT).build(), (Object)ColumnMetadata.builder().setName("cola_").setType((Type)BigintType.BIGINT).build(), (Object)ColumnMetadata.builder().setName("colabc").setType((Type)BigintType.BIGINT).build())).withListSchemaNames(session -> ImmutableList.of((Object)"mockschema")).withListTables((session, schemaName) -> ImmutableList.of((Object)new SchemaTableName("mockSchema", "mockTable"))).build(), (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)queryRunner);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testShowCatalogsLikeWithEscape() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW CATALOGS LIKE 't$_%' ESCAPE ''")).hasMessage("Escape string must be a single character");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW CATALOGS LIKE 't$_%' ESCAPE '$$'")).hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE '%$_%' ESCAPE '$'")))).matches("VALUES('testing_catalog')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE '$_%' ESCAPE '$'")))).matches("SELECT 'testing_catalog' WHERE FALSE");
    }

    @Test
    public void testShowFunctionLike() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW FUNCTIONS LIKE 'split%'")))).matches("VALUES (cast('split' AS VARCHAR(30)), cast('array(varchar(x))' AS VARCHAR(28)), cast('varchar(x), varchar(y)' AS VARCHAR(68)), cast('scalar' AS VARCHAR(9)), true, cast('' AS VARCHAR(131))),('split', 'array(varchar(x))', 'varchar(x), varchar(y), bigint', 'scalar', true, ''),('split_part', 'varchar(x)', 'varchar(x), varchar(y), bigint', 'scalar', true, 'Splits a string by a delimiter and returns the specified field (counting from one)'),('split_to_map', 'map(varchar,varchar)', 'varchar, varchar, varchar', 'scalar', true, 'Creates a map using entryDelimiter and keyValueDelimiter'),('split_to_multimap', 'map(varchar,array(varchar))', 'varchar, varchar, varchar', 'scalar', true, 'Creates a multimap by splitting a string into key/value pairs')");
    }

    @Test
    public void testShowFunctionsLikeWithEscape() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW FUNCTIONS LIKE 'split$_to$_%' ESCAPE '$'")))).matches("VALUES (cast('split_to_map' AS VARCHAR(30)), cast('map(varchar,varchar)' AS VARCHAR(28)), cast('varchar, varchar, varchar' AS VARCHAR(68)), cast('scalar' AS VARCHAR(9)), true, cast('Creates a map using entryDelimiter and keyValueDelimiter' AS VARCHAR(131))),('split_to_multimap', 'map(varchar,array(varchar))', 'varchar, varchar, varchar', 'scalar', true, 'Creates a multimap by splitting a string into key/value pairs')");
    }

    @Test
    public void testShowSessionLike() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE '%page_row_c%'")))).matches("VALUES ('filter_and_project_min_output_page_row_count', cast('256' as VARCHAR(14)), cast('256' as VARCHAR(14)), 'integer', cast('Experimental: Minimum output page row count for filter and project operators' as VARCHAR(96)))");
    }

    @Test
    public void testShowSessionLikeWithEscape() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW SESSION LIKE 't$_%' ESCAPE ''")).hasMessage("Escape string must be a single character");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW SESSION LIKE 't$_%' ESCAPE '$$'")).hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE '%page$_row$_c%' ESCAPE '$'")))).matches("VALUES ('filter_and_project_min_output_page_row_count', cast('256' as VARCHAR(14)), cast('256' as VARCHAR(14)), 'integer', cast('Experimental: Minimum output page row count for filter and project operators' as VARCHAR(96)))");
    }

    @Test
    public void testListingEmptyCatalogs() {
        this.assertions.executeExclusively(() -> {
            this.assertions.getQueryRunner().getAccessControl().denyCatalogs(catalog -> false);
            this.assertions.assertQueryReturnsEmptyResult("SHOW CATALOGS");
            this.assertions.getQueryRunner().getAccessControl().reset();
        });
    }

    @Test
    public void testShowColumns() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable")))).matches("VALUES (CAST('colaa' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR)),(CAST('cola_' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR)),(CAST('colabc' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR))");
    }

    @Test
    public void testShowColumnsLike() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'colabc'")))).matches("VALUES (CAST('colabc' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'cola%'")))).matches("VALUES (CAST('colaa' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR)),(CAST('cola_' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR)),(CAST('colabc' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'cola_'")))).matches("VALUES (CAST('colaa' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR)),(CAST('cola_' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 'node%'")))).matches("VALUES (CAST('node_id' AS VARCHAR), CAST('varchar' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR)),(CAST('node_version' AS VARCHAR), CAST('varchar' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 'node_id'")))).matches("VALUES (CAST('node_id' AS VARCHAR), CAST('varchar' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR))");
        Assert.assertEquals((int)this.assertions.execute("SHOW COLUMNS FROM system.runtime.nodes LIKE ''").getRowCount(), (int)0);
    }

    @Test
    public void testShowColumnsWithLikeWithEscape() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 't$_%' ESCAPE ''")).hasMessage("Escape string must be a single character");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 't$_%' ESCAPE '$$'")).hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable LIKE 'cola$_' ESCAPE '$'")))).matches("VALUES (CAST('cola_' AS VARCHAR), CAST('bigint' AS VARCHAR) , CAST('' AS VARCHAR), CAST('' AS VARCHAR))");
    }
}

