/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.query;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWith {
    private static final String CATALOG = "local";
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        Session session = TestingSession.testSessionBuilder().setCatalog(CATALOG).setSchema("tiny").build();
        LocalQueryRunner runner = LocalQueryRunner.builder((Session)session).build();
        runner.createCatalog(CATALOG, (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testWithHiddenFields() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(String.format("SELECT count(*) FROM information_schema.columns WHERE table_catalog = '%s' and table_schema = '%s' and table_name = 'nation' and column_name = 'row_number'", CATALOG, "tiny"))))).matches("VALUES BIGINT '0'");
        this.assertions.execute("SELECT min(row_number) FROM nation");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(a, b, c, d) AS (TABLE nation) SELECT a, b FROM t WHERE a = 1")))).matches("VALUES (BIGINT '1', CAST('ARGENTINA' AS VARCHAR(25)))");
    }
}

