/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.transaction;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.transaction.TransactionManagerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestTransactionManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((TransactionManagerConfig)ConfigAssertions.recordDefaults(TransactionManagerConfig.class)).setIdleCheckInterval(new Duration(1.0, TimeUnit.MINUTES)).setIdleTimeout(new Duration(5.0, TimeUnit.MINUTES)).setMaxFinishingConcurrency(1));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"transaction.idle-check-interval", (Object)"1s").put((Object)"transaction.idle-timeout", (Object)"10s").put((Object)"transaction.max-finishing-concurrency", (Object)"100").build();
        TransactionManagerConfig expected = new TransactionManagerConfig().setIdleCheckInterval(new Duration(1.0, TimeUnit.SECONDS)).setIdleTimeout(new Duration(10.0, TimeUnit.SECONDS)).setMaxFinishingConcurrency(100);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

