/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.prestosql.type.BigintOperators;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=100, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=100, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.Throughput})
public class BenchmarkBigIntOperators {
    private long leftOperand0;
    private long leftOperand1;
    private long leftOperand2;
    private long leftOperand3;
    private long leftOperand4;
    private long rightOperand0;
    private long rightOperand1;
    private long rightOperand2;
    private long rightOperand3;
    private long rightOperand4;

    @Setup
    public void setup() {
        this.leftOperand0 = 1L;
        this.leftOperand1 = 20L;
        this.leftOperand2 = 33L;
        this.leftOperand3 = 407L;
        this.leftOperand4 = 7890L;
        this.rightOperand0 = 123456L;
        this.rightOperand1 = 9003L;
        this.rightOperand2 = 809L;
        this.rightOperand3 = 67L;
        this.rightOperand4 = 5L;
    }

    @Benchmark
    public Object overflowChecksAdd() {
        long result = 0L;
        result += BigintOperators.add((long)this.leftOperand0, (long)this.rightOperand0);
        result += BigintOperators.add((long)this.leftOperand1, (long)this.rightOperand0);
        result += BigintOperators.add((long)this.leftOperand2, (long)this.rightOperand0);
        result += BigintOperators.add((long)this.leftOperand3, (long)this.rightOperand0);
        result += BigintOperators.add((long)this.leftOperand4, (long)this.rightOperand0);
        result += BigintOperators.add((long)this.leftOperand0, (long)this.rightOperand1);
        result += BigintOperators.add((long)this.leftOperand1, (long)this.rightOperand1);
        result += BigintOperators.add((long)this.leftOperand2, (long)this.rightOperand1);
        result += BigintOperators.add((long)this.leftOperand3, (long)this.rightOperand1);
        result += BigintOperators.add((long)this.leftOperand4, (long)this.rightOperand1);
        result += BigintOperators.add((long)this.leftOperand0, (long)this.rightOperand2);
        result += BigintOperators.add((long)this.leftOperand1, (long)this.rightOperand2);
        result += BigintOperators.add((long)this.leftOperand2, (long)this.rightOperand2);
        result += BigintOperators.add((long)this.leftOperand3, (long)this.rightOperand2);
        result += BigintOperators.add((long)this.leftOperand4, (long)this.rightOperand2);
        result += BigintOperators.add((long)this.leftOperand0, (long)this.rightOperand3);
        result += BigintOperators.add((long)this.leftOperand1, (long)this.rightOperand3);
        result += BigintOperators.add((long)this.leftOperand2, (long)this.rightOperand3);
        result += BigintOperators.add((long)this.leftOperand3, (long)this.rightOperand3);
        result += BigintOperators.add((long)this.leftOperand4, (long)this.rightOperand3);
        result += BigintOperators.add((long)this.leftOperand0, (long)this.rightOperand4);
        result += BigintOperators.add((long)this.leftOperand1, (long)this.rightOperand4);
        result += BigintOperators.add((long)this.leftOperand2, (long)this.rightOperand4);
        result += BigintOperators.add((long)this.leftOperand3, (long)this.rightOperand4);
        return result += BigintOperators.add((long)this.leftOperand4, (long)this.rightOperand4);
    }

    @Benchmark
    public Object overflowChecksSubtract() {
        long result = 0L;
        result += BigintOperators.subtract((long)this.leftOperand0, (long)this.rightOperand0);
        result += BigintOperators.subtract((long)this.leftOperand1, (long)this.rightOperand0);
        result += BigintOperators.subtract((long)this.leftOperand2, (long)this.rightOperand0);
        result += BigintOperators.subtract((long)this.leftOperand3, (long)this.rightOperand0);
        result += BigintOperators.subtract((long)this.leftOperand4, (long)this.rightOperand0);
        result += BigintOperators.subtract((long)this.leftOperand0, (long)this.rightOperand1);
        result += BigintOperators.subtract((long)this.leftOperand1, (long)this.rightOperand1);
        result += BigintOperators.subtract((long)this.leftOperand2, (long)this.rightOperand1);
        result += BigintOperators.subtract((long)this.leftOperand3, (long)this.rightOperand1);
        result += BigintOperators.subtract((long)this.leftOperand4, (long)this.rightOperand1);
        result += BigintOperators.subtract((long)this.leftOperand0, (long)this.rightOperand2);
        result += BigintOperators.subtract((long)this.leftOperand1, (long)this.rightOperand2);
        result += BigintOperators.subtract((long)this.leftOperand2, (long)this.rightOperand2);
        result += BigintOperators.subtract((long)this.leftOperand3, (long)this.rightOperand2);
        result += BigintOperators.subtract((long)this.leftOperand4, (long)this.rightOperand2);
        result += BigintOperators.subtract((long)this.leftOperand0, (long)this.rightOperand3);
        result += BigintOperators.subtract((long)this.leftOperand1, (long)this.rightOperand3);
        result += BigintOperators.subtract((long)this.leftOperand2, (long)this.rightOperand3);
        result += BigintOperators.subtract((long)this.leftOperand3, (long)this.rightOperand3);
        result += BigintOperators.subtract((long)this.leftOperand4, (long)this.rightOperand3);
        result += BigintOperators.subtract((long)this.leftOperand0, (long)this.rightOperand4);
        result += BigintOperators.subtract((long)this.leftOperand1, (long)this.rightOperand4);
        result += BigintOperators.subtract((long)this.leftOperand2, (long)this.rightOperand4);
        result += BigintOperators.subtract((long)this.leftOperand3, (long)this.rightOperand4);
        return result += BigintOperators.subtract((long)this.leftOperand4, (long)this.rightOperand4);
    }

    @Benchmark
    public Object overflowChecksMultiply() {
        long result = 0L;
        result += BigintOperators.multiply((long)this.leftOperand0, (long)this.rightOperand0);
        result += BigintOperators.multiply((long)this.leftOperand1, (long)this.rightOperand0);
        result += BigintOperators.multiply((long)this.leftOperand2, (long)this.rightOperand0);
        result += BigintOperators.multiply((long)this.leftOperand3, (long)this.rightOperand0);
        result += BigintOperators.multiply((long)this.leftOperand4, (long)this.rightOperand0);
        result += BigintOperators.multiply((long)this.leftOperand0, (long)this.rightOperand1);
        result += BigintOperators.multiply((long)this.leftOperand1, (long)this.rightOperand1);
        result += BigintOperators.multiply((long)this.leftOperand2, (long)this.rightOperand1);
        result += BigintOperators.multiply((long)this.leftOperand3, (long)this.rightOperand1);
        result += BigintOperators.multiply((long)this.leftOperand4, (long)this.rightOperand1);
        result += BigintOperators.multiply((long)this.leftOperand0, (long)this.rightOperand2);
        result += BigintOperators.multiply((long)this.leftOperand1, (long)this.rightOperand2);
        result += BigintOperators.multiply((long)this.leftOperand2, (long)this.rightOperand2);
        result += BigintOperators.multiply((long)this.leftOperand3, (long)this.rightOperand2);
        result += BigintOperators.multiply((long)this.leftOperand4, (long)this.rightOperand2);
        result += BigintOperators.multiply((long)this.leftOperand0, (long)this.rightOperand3);
        result += BigintOperators.multiply((long)this.leftOperand1, (long)this.rightOperand3);
        result += BigintOperators.multiply((long)this.leftOperand2, (long)this.rightOperand3);
        result += BigintOperators.multiply((long)this.leftOperand3, (long)this.rightOperand3);
        result += BigintOperators.multiply((long)this.leftOperand4, (long)this.rightOperand3);
        result += BigintOperators.multiply((long)this.leftOperand0, (long)this.rightOperand4);
        result += BigintOperators.multiply((long)this.leftOperand1, (long)this.rightOperand4);
        result += BigintOperators.multiply((long)this.leftOperand2, (long)this.rightOperand4);
        result += BigintOperators.multiply((long)this.leftOperand3, (long)this.rightOperand4);
        return result += BigintOperators.multiply((long)this.leftOperand4, (long)this.rightOperand4);
    }

    @Benchmark
    public Object overflowChecksDivide() {
        long result = 0L;
        result += BigintOperators.divide((long)this.leftOperand0, (long)this.rightOperand0);
        result += BigintOperators.divide((long)this.leftOperand1, (long)this.rightOperand0);
        result += BigintOperators.divide((long)this.leftOperand2, (long)this.rightOperand0);
        result += BigintOperators.divide((long)this.leftOperand3, (long)this.rightOperand0);
        result += BigintOperators.divide((long)this.leftOperand4, (long)this.rightOperand0);
        result += BigintOperators.divide((long)this.leftOperand0, (long)this.rightOperand1);
        result += BigintOperators.divide((long)this.leftOperand1, (long)this.rightOperand1);
        result += BigintOperators.divide((long)this.leftOperand2, (long)this.rightOperand1);
        result += BigintOperators.divide((long)this.leftOperand3, (long)this.rightOperand1);
        result += BigintOperators.divide((long)this.leftOperand4, (long)this.rightOperand1);
        result += BigintOperators.divide((long)this.leftOperand0, (long)this.rightOperand2);
        result += BigintOperators.divide((long)this.leftOperand1, (long)this.rightOperand2);
        result += BigintOperators.divide((long)this.leftOperand2, (long)this.rightOperand2);
        result += BigintOperators.divide((long)this.leftOperand3, (long)this.rightOperand2);
        result += BigintOperators.divide((long)this.leftOperand4, (long)this.rightOperand2);
        result += BigintOperators.divide((long)this.leftOperand0, (long)this.rightOperand3);
        result += BigintOperators.divide((long)this.leftOperand1, (long)this.rightOperand3);
        result += BigintOperators.divide((long)this.leftOperand2, (long)this.rightOperand3);
        result += BigintOperators.divide((long)this.leftOperand3, (long)this.rightOperand3);
        result += BigintOperators.divide((long)this.leftOperand4, (long)this.rightOperand3);
        result += BigintOperators.divide((long)this.leftOperand0, (long)this.rightOperand4);
        result += BigintOperators.divide((long)this.leftOperand1, (long)this.rightOperand4);
        result += BigintOperators.divide((long)this.leftOperand2, (long)this.rightOperand4);
        result += BigintOperators.divide((long)this.leftOperand3, (long)this.rightOperand4);
        return result += BigintOperators.divide((long)this.leftOperand4, (long)this.rightOperand4);
    }

    @Benchmark
    public Object overflowChecksNegate() {
        long result = 0L;
        result += BigintOperators.negate((long)this.leftOperand0);
        result += BigintOperators.negate((long)this.leftOperand1);
        result += BigintOperators.negate((long)this.leftOperand2);
        result += BigintOperators.negate((long)this.leftOperand3);
        result += BigintOperators.negate((long)this.leftOperand4);
        result += BigintOperators.negate((long)this.rightOperand0);
        result += BigintOperators.negate((long)this.rightOperand1);
        result += BigintOperators.negate((long)this.rightOperand2);
        result += BigintOperators.negate((long)this.rightOperand3);
        return result += BigintOperators.negate((long)this.rightOperand4);
    }

    @Benchmark
    public Object baseLineAdd() {
        long result = 0L;
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand0, this.rightOperand0);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand1, this.rightOperand0);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand2, this.rightOperand0);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand3, this.rightOperand0);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand4, this.rightOperand0);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand0, this.rightOperand1);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand1, this.rightOperand1);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand2, this.rightOperand1);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand3, this.rightOperand1);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand4, this.rightOperand1);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand0, this.rightOperand2);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand1, this.rightOperand2);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand2, this.rightOperand2);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand3, this.rightOperand2);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand4, this.rightOperand2);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand0, this.rightOperand3);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand1, this.rightOperand3);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand2, this.rightOperand3);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand3, this.rightOperand3);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand4, this.rightOperand3);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand0, this.rightOperand4);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand1, this.rightOperand4);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand2, this.rightOperand4);
        result += BenchmarkBigIntOperators.addBaseline(this.leftOperand3, this.rightOperand4);
        return result += BenchmarkBigIntOperators.addBaseline(this.leftOperand4, this.rightOperand4);
    }

    @Benchmark
    public Object baseLineSubtract() {
        long result = 0L;
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand0, this.rightOperand0);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand1, this.rightOperand0);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand2, this.rightOperand0);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand3, this.rightOperand0);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand4, this.rightOperand0);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand0, this.rightOperand1);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand1, this.rightOperand1);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand2, this.rightOperand1);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand3, this.rightOperand1);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand4, this.rightOperand1);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand0, this.rightOperand2);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand1, this.rightOperand2);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand2, this.rightOperand2);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand3, this.rightOperand2);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand4, this.rightOperand2);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand0, this.rightOperand3);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand1, this.rightOperand3);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand2, this.rightOperand3);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand3, this.rightOperand3);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand4, this.rightOperand3);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand0, this.rightOperand4);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand1, this.rightOperand4);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand2, this.rightOperand4);
        result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand3, this.rightOperand4);
        return result += BenchmarkBigIntOperators.subtractBaseline(this.leftOperand4, this.rightOperand4);
    }

    @Benchmark
    public Object baseLineMultiply() {
        long result = 0L;
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand0, this.rightOperand0);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand1, this.rightOperand0);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand2, this.rightOperand0);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand3, this.rightOperand0);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand4, this.rightOperand0);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand0, this.rightOperand1);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand1, this.rightOperand1);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand2, this.rightOperand1);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand3, this.rightOperand1);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand4, this.rightOperand1);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand0, this.rightOperand2);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand1, this.rightOperand2);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand2, this.rightOperand2);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand3, this.rightOperand2);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand4, this.rightOperand2);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand0, this.rightOperand3);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand1, this.rightOperand3);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand2, this.rightOperand3);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand3, this.rightOperand3);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand4, this.rightOperand3);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand0, this.rightOperand4);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand1, this.rightOperand4);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand2, this.rightOperand4);
        result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand3, this.rightOperand4);
        return result += BenchmarkBigIntOperators.multiplyBaseline(this.leftOperand4, this.rightOperand4);
    }

    @Benchmark
    public Object baseLineDivide() {
        long result = 0L;
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand0, this.rightOperand0);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand1, this.rightOperand0);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand2, this.rightOperand0);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand3, this.rightOperand0);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand4, this.rightOperand0);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand0, this.rightOperand1);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand1, this.rightOperand1);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand2, this.rightOperand1);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand3, this.rightOperand1);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand4, this.rightOperand1);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand0, this.rightOperand2);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand1, this.rightOperand2);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand2, this.rightOperand2);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand3, this.rightOperand2);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand4, this.rightOperand2);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand0, this.rightOperand3);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand1, this.rightOperand3);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand2, this.rightOperand3);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand3, this.rightOperand3);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand4, this.rightOperand3);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand0, this.rightOperand4);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand1, this.rightOperand4);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand2, this.rightOperand4);
        result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand3, this.rightOperand4);
        return result += BenchmarkBigIntOperators.divideBaseline(this.leftOperand4, this.rightOperand4);
    }

    @Benchmark
    public Object baseLineNegate() {
        long result = 0L;
        result += BenchmarkBigIntOperators.negateBaseLine(this.leftOperand0);
        result += BenchmarkBigIntOperators.negateBaseLine(this.leftOperand1);
        result += BenchmarkBigIntOperators.negateBaseLine(this.leftOperand2);
        result += BenchmarkBigIntOperators.negateBaseLine(this.leftOperand3);
        result += BenchmarkBigIntOperators.negateBaseLine(this.leftOperand4);
        result += BenchmarkBigIntOperators.negateBaseLine(this.rightOperand0);
        result += BenchmarkBigIntOperators.negateBaseLine(this.rightOperand1);
        result += BenchmarkBigIntOperators.negateBaseLine(this.rightOperand2);
        result += BenchmarkBigIntOperators.negateBaseLine(this.rightOperand3);
        return result += BenchmarkBigIntOperators.negateBaseLine(this.rightOperand4);
    }

    private static long addBaseline(long first, long second) {
        return first + second;
    }

    private static long subtractBaseline(long first, long second) {
        return first - second;
    }

    private static long multiplyBaseline(long first, long second) {
        return first * second;
    }

    private static long divideBaseline(long first, long second) {
        return first / second;
    }

    private static long negateBaseLine(long x) {
        return -x;
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkBigIntOperators.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

